/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import org.slf4j.Logger;

final class Hexadecimal {
    static final String ILC_START = "\u169b";
    static final String ILC_END = "\u169c";
    private final int value;
    private final Logger logger;

    Hexadecimal(int value, Logger logger) {
        this.value = value;
        this.logger = logger;
    }

    public String toString() {
        switch (this.value) {
            case 4: {
                return "\u00ad";
            }
            case 5: {
                return "\u200d";
            }
            case 6: {
                return "";
            }
            case 8: {
                return "\t";
            }
            case 9: {
                return "\n";
            }
            case 10: {
                return "\u169b\\x0a \u169c";
            }
            case 11: {
                return "\u169b\\x0b \u169c";
            }
            case 16: {
                return "\u2007";
            }
            case 17: {
                return "\u00a0";
            }
            case 18: {
                return "\u2009";
            }
            case 19: {
                return "\u2002";
            }
            case 20: {
                return "\u2003";
            }
            case 21: {
                return "\u2011";
            }
        }
        this.logger.warn("Unknown hexadecimal '{}' will be extracted as an inline code.", (Object)this.value);
        return String.format("%s\\x%02x %s", ILC_START, this.value, ILC_END);
    }
}

