/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown.parser;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.sf.okapi.filters.markdown.parser.MarkdownToken;

public enum MarkdownTokenType {
    AUTO_LINK,
    BLANK_LINE,
    BLOCK_QUOTE,
    BULLET_LIST,
    BULLET_LIST_ITEM,
    CODE,
    EMPHASIS,
    FENCED_CODE_BLOCK,
    FENCED_CODE_BLOCK_INFO,
    HARD_LINE_BREAK,
    HEADING_PREFIX,
    HEADING_UNDERLINE,
    HTML_BLOCK,
    HTML_COMMENT_BLOCK,
    HTML_ENTITY,
    HTML_INLINE,
    HTML_INLINE_COMMENT,
    HTML_INNER_BLOCK,
    HTML_INNER_BLOCK_COMMENT,
    IMAGE,
    IMAGE_REF,
    INDENTED_CODE_BLOCK,
    LINK,
    LINK_REF,
    MAIL_LINK,
    ORDERED_LIST,
    ORDERED_LIST_ITEM,
    REFERENCE,
    SOFT_LINE_BREAK,
    STRONG_EMPHASIS,
    TEXT,
    THEMATIC_BREAK,
    WHITE_SPACE,
    TABLE_PIPE,
    TABLE_SEPARATOR,
    YAML_METADATA_HEADER,
    STRIKETHROUGH,
    SUBSCRIPT,
    END_TEXT_UNIT,
    LINE_PREFIX;

    private static EnumSet<MarkdownTokenType> inlineTokenTypes;
    private static Set<String> htmlBlockTokens;

    public boolean isInline() {
        return inlineTokenTypes.contains((Object)this);
    }

    public static boolean isMisclassifiedHtmlBlockToken(MarkdownToken token) {
        return htmlBlockTokens.contains(token.getContent()) && token.getType().equals((Object)HTML_INLINE);
    }

    static {
        inlineTokenTypes = EnumSet.of(EMPHASIS, new MarkdownTokenType[]{STRONG_EMPHASIS, STRIKETHROUGH, SUBSCRIPT, HARD_LINE_BREAK, CODE, IMAGE, IMAGE_REF, LINK, LINK_REF});
        htmlBlockTokens = new HashSet<String>(Arrays.asList("<div>", "</div>", "<ul>", "</ul>", "<li>", "</li>"));
    }
}

