/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.StoryChildElement;

class Story {
    private final XMLEvent startDocumentEvent;
    private final StartElement wrappingStoryStartElement;
    private final StartElement storyStartElement;
    private final List<StoryChildElement> childElements;
    private final EndElement storyEndElement;
    private final EndElement wrappingStoryEndElement;
    private final XMLEvent endDocumentEvent;

    Story(XMLEvent startDocumentEvent, StartElement wrappingStoryStartElement, StartElement storyStartElement, List<StoryChildElement> childElements, EndElement storyEndElement, EndElement wrappingStoryEndElement, XMLEvent endDocumentEvent) {
        this.startDocumentEvent = startDocumentEvent;
        this.wrappingStoryStartElement = wrappingStoryStartElement;
        this.storyStartElement = storyStartElement;
        this.childElements = childElements;
        this.storyEndElement = storyEndElement;
        this.wrappingStoryEndElement = wrappingStoryEndElement;
        this.endDocumentEvent = endDocumentEvent;
    }

    XMLEvent getStartDocumentEvent() {
        return this.startDocumentEvent;
    }

    StartElement getWrappingStoryStartElement() {
        return this.wrappingStoryStartElement;
    }

    StartElement getStoryStartElement() {
        return this.storyStartElement;
    }

    List<StoryChildElement> getChildElements() {
        return this.childElements;
    }

    EndElement getStoryEndElement() {
        return this.storyEndElement;
    }

    EndElement getWrappingStoryEndElement() {
        return this.wrappingStoryEndElement;
    }

    XMLEvent getEndDocumentEvent() {
        return this.endDocumentEvent;
    }

    static class StoryBuilder
    implements Builder<Story> {
        private XMLEvent startDocumentEvent;
        private StartElement wrappingStoryStartElement;
        private StartElement storyStartElement;
        private List<StoryChildElement> childElements = new ArrayList<StoryChildElement>();
        private EndElement storyEndElement;
        private EndElement wrappingStoryEndElement;
        private XMLEvent endDocumentEvent;

        StoryBuilder() {
        }

        StoryBuilder setStartDocumentEvent(XMLEvent startDocument) {
            this.startDocumentEvent = startDocument;
            return this;
        }

        StoryBuilder setWrappingStoryStartElement(StartElement wrappingStoryStartElement) {
            this.wrappingStoryStartElement = wrappingStoryStartElement;
            return this;
        }

        StoryBuilder setStoryStartElement(StartElement storyStartElement) {
            this.storyStartElement = storyStartElement;
            return this;
        }

        StoryBuilder addChildElements(List<StoryChildElement> storyChildElements) {
            this.childElements.addAll(storyChildElements);
            return this;
        }

        StoryBuilder setStoryEndElement(EndElement storyEndElement) {
            this.storyEndElement = storyEndElement;
            return this;
        }

        StoryBuilder setWrappingStoryEndElement(EndElement wrappingStoryEndElement) {
            this.wrappingStoryEndElement = wrappingStoryEndElement;
            return this;
        }

        StoryBuilder setEndDocumentEvent(XMLEvent endDocumentEvent) {
            this.endDocumentEvent = endDocumentEvent;
            return this;
        }

        @Override
        public Story build() {
            return new Story(this.startDocumentEvent, this.wrappingStoryStartElement, this.storyStartElement, this.childElements, this.storyEndElement, this.wrappingStoryEndElement, this.endDocumentEvent);
        }
    }
}

