/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.GeometryPath;

class Property
implements Element {
    private final Element.Default defaultElement;

    Property(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, XMLEventFactory eventFactory) {
        this(new Element.Default(startElement, innerEvents, endElement, eventFactory));
    }

    Property(Element.Default defaultElement) {
        this.defaultElement = defaultElement;
    }

    @Override
    public StartElement startElement() {
        return this.defaultElement.startElement();
    }

    @Override
    public List<XMLEvent> innerEvents() {
        return this.defaultElement.innerEvents();
    }

    @Override
    public void updateInnerEventsWith(List<XMLEvent> events) {
        this.defaultElement.updateInnerEventsWith(events);
    }

    @Override
    public EndElement endElement() {
        return this.defaultElement.endElement();
    }

    @Override
    public void apply(FontMappings fontMappings) {
        StringBuilder sb = new StringBuilder();
        this.innerEvents().forEach(e -> sb.append(e.asCharacters().getData()));
        String sourceFont = sb.toString();
        String targetFont = fontMappings.targetFontFor(sourceFont);
        if (!targetFont.equals(sourceFont)) {
            this.updateInnerEventsWith(Collections.singletonList(this.defaultElement.eventFactory().createCharacters(targetFont)));
        }
    }

    @Override
    public List<XMLEvent> getEvents() {
        return this.defaultElement.getEvents();
    }

    @Override
    public QName getName() {
        return this.defaultElement.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        Property that = (Property)o;
        return Objects.equals(this.startElement(), that.startElement()) && Objects.equals(this.innerEvents(), that.innerEvents()) && Objects.equals(this.endElement(), that.endElement());
    }

    public int hashCode() {
        return Objects.hash(this.startElement(), this.innerEvents(), this.endElement());
    }

    static class PathGeometryProperty
    extends Property {
        private final List<GeometryPath> geometryPaths;

        PathGeometryProperty(StartElement startElement, List<GeometryPath> geometryPaths, EndElement endElement, XMLEventFactory eventFactory) {
            super(startElement, Collections.emptyList(), endElement, eventFactory);
            this.geometryPaths = geometryPaths;
        }

        @Override
        public List<XMLEvent> innerEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            for (GeometryPath geometryPath : this.geometryPaths) {
                events.addAll(geometryPath.getEvents());
            }
            return events;
        }

        List<GeometryPath> getGeometryPaths() {
            return this.geometryPaths;
        }

        static class Builder
        extends net.sf.okapi.filters.idml.Property$Builder {
            private List<GeometryPath> geometryPaths = new ArrayList<GeometryPath>();

            Builder() {
            }

            Builder addGeometryPath(GeometryPath geometryPath) {
                this.geometryPaths.add(geometryPath);
                return this;
            }

            @Override
            public PathGeometryProperty build() {
                return new PathGeometryProperty(this.startElement, this.geometryPaths, this.endElement, this.eventFactory);
            }
        }
    }

    static class Builder
    extends Element.Builder {
        Builder() {
        }

        @Override
        public Property build() {
            return new Property(this.startElement, this.innerEvents, this.endElement, this.eventFactory);
        }
    }
}

