/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import net.sf.okapi.common.DefaultLocalePair;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.MarkupZipSkeleton;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ReferenceableEventsMerger;
import net.sf.okapi.filters.idml.ReferenceableEventsWriter;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;
import net.sf.okapi.filters.idml.SubDocumentWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDMLFilterWriter
implements IFilterWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Parameters parameters;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private final String encoding;
    private final String lineBreak;
    private String outputPath;
    private ZipFile zipOriginal;
    private ZipOutputStream zipOutputStream;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private EncoderManager encoderManager;
    private IFilterWriter subDocWriter;
    private Deque<SubDocumentValues> tmSubDoc = new ArrayDeque<SubDocumentValues>();
    private OutputStream outputStream;

    IDMLFilterWriter(Parameters parameters, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String encoding, String lineBreak) {
        this.parameters = parameters;
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
        this.encoding = encoding;
        this.lineBreak = lineBreak;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.zipOutputStream == null) {
            return;
        }
        try {
            if (this.zipOriginal != null) {
                this.zipOriginal.close();
                this.zipOriginal = null;
            }
            this.zipOutputStream.close();
            this.zipOutputStream = null;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing IDML output.\n" + e.getMessage(), e);
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public String getName() {
        return "IDMLFilterWriter";
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                try {
                    this.subDocWriter.handleEvent(event);
                    break;
                }
                catch (Throwable e) {
                    String mess = e.getMessage();
                    throw new OkapiNotImplementedException(mess, e);
                }
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.targetLocale = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    private void processStartDocument(StartDocument res) {
        try {
            this.sourceLocale = res.getLocale();
            ZipFile zipFile = ((ZipSkeleton)res.getSkeleton()).getOriginal();
            this.zipOriginal = new ZipFile(new File(zipFile.getName()), 1);
            OutputStream os = this.outputStream;
            if (os == null) {
                File f = new File(this.outputPath);
                boolean useTemp = false;
                if (f.exists()) {
                    boolean bl = useTemp = !Files.deleteIfExists(f.toPath());
                }
                if (useTemp) {
                    File tempZip = File.createTempFile("~okapi-22_idmlTmpZip_", null);
                    os = new FileOutputStream(tempZip.getAbsolutePath());
                } else {
                    Util.createDirectories(this.outputPath);
                    os = new FileOutputStream(this.outputPath);
                }
            }
            this.zipOutputStream = new ZipOutputStream(os);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating output IDML.\n" + e.getMessage(), e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processDocumentPart(Event event) {
        DocumentPart documentPart = (DocumentPart)event.getResource();
        if (!(documentPart.getSkeleton() instanceof ZipSkeleton)) {
            this.subDocWriter.handleEvent(event);
            return;
        }
        ZipSkeleton skeleton = (ZipSkeleton)documentPart.getSkeleton();
        if (skeleton instanceof MarkupZipSkeleton) {
            ((MarkupZipSkeleton)skeleton).markup().apply(this.parameters.fontMappings().applicableTo(new DefaultLocalePair(this.sourceLocale, this.targetLocale)));
        }
        try {
            this.zipOutputStream.putNextEntry(new ZipEntry(skeleton.getEntry().getName()));
            String modifiedContents = skeleton.getModifiedContents();
            if (modifiedContents != null) {
                this.zipOutputStream.write(modifiedContents.getBytes(this.encoding));
            } else {
                try (InputStream input = this.zipOriginal.getInputStream(skeleton.getEntry());){
                    int len;
                    byte[] buffer = new byte[2048];
                    while ((len = input.read(buffer)) > 0) {
                        this.zipOutputStream.write(buffer, 0, len);
                    }
                }
            }
            this.zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing zip file entry.");
        }
    }

    private void processStartSubDocument(StartSubDocument res) {
        File subdocTempFile;
        try {
            subdocTempFile = File.createTempFile("~okapi-22_idmlTmp" + this.tmSubDoc.size() + "_", null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error opening temporary zip output file.");
        }
        this.subDocWriter = new SubDocumentWriter(this.parameters, this.outputFactory, this.encoding, subdocTempFile.getAbsolutePath(), new ReferenceableEventsWriter(new ReferenceableEventsMerger(this.eventFactory, new DefaultLocalePair(this.sourceLocale, this.targetLocale), this.parameters.fontMappings()), new StyleRangeEventsGenerator(this.eventFactory)));
        StartDocument sd = new StartDocument("sd");
        sd.setLineBreak(this.lineBreak);
        sd.setSkeleton(res.getSkeleton());
        sd.setLocale(this.sourceLocale);
        this.subDocWriter.handleEvent(new Event(EventType.START_DOCUMENT, sd));
        ZipEntry subDocEntry = ((ZipSkeleton)res.getSkeleton()).getEntry();
        SubDocumentValues subDocumentValues = new SubDocumentValues(subDocEntry, subdocTempFile);
        this.tmSubDoc.push(subDocumentValues);
    }

    private void processEndSubDocument(Ending res) {
        try {
            this.subDocWriter.handleEvent(new Event(EventType.END_DOCUMENT, res));
            this.subDocWriter.close();
            SubDocumentValues subDocumentValues = this.tmSubDoc.pop();
            File subdocTempFile = subDocumentValues.getTempFile();
            ZipEntry subDocEntry = subDocumentValues.getZipEntry();
            this.zipOutputStream.putNextEntry(new ZipEntry(subDocEntry.getName()));
            Files.copy(subdocTempFile.toPath(), this.zipOutputStream);
            this.zipOutputStream.closeEntry();
            Files.deleteIfExists(subdocTempFile.toPath());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zip output file.");
        }
    }

    private static class SubDocumentValues {
        private final ZipEntry zipEntry;
        private final File tempFile;

        SubDocumentValues(ZipEntry zipEntry, File tempFile) {
            this.zipEntry = zipEntry;
            this.tempFile = tempFile;
        }

        ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        File getTempFile() {
            return this.tempFile;
        }
    }
}

