/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.kantan;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class KantanMTv21ConnectorParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String API_TOKEN = "apiToken";
    private static final String ENGINE = "engine";
    private static final String ALIAS = "alias";

    public void setApiToken(String apiToken) {
        this.setString(API_TOKEN, apiToken);
    }

    public String getApiToken() {
        return this.getString(API_TOKEN);
    }

    public void setEngine(String engine) {
        this.setString(ENGINE, engine);
    }

    public String getEngine() {
        return this.getString(ENGINE);
    }

    public void setAlias(String alias) {
        this.setString(ALIAS, alias);
    }

    public String getAlias() {
        return this.getString(ALIAS);
    }

    @Override
    public void reset() {
        super.reset();
        this.setApiToken("");
        this.setEngine("");
        this.setAlias("");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(API_TOKEN, "Token", "KantanMT API Authorization Token");
        desc.add(ENGINE, "Engine name (or use Alias name)", "Name of the engine to use");
        desc.add(ALIAS, "Alias name (or use Engine name)", "Name of the alias for the engine to use");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("KantanMT v2.1 Connector Settings", true, false);
        TextInputPart tipSecret = desc.addTextInputPart(parametersDescription.get(API_TOKEN));
        tipSecret.setPassword(true);
        TextInputPart tip = desc.addTextInputPart(parametersDescription.get(ENGINE));
        tip.setAllowEmpty(true);
        tip = desc.addTextInputPart(parametersDescription.get(ALIAS));
        tip.setAllowEmpty(true);
        return desc;
    }
}

