/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.okapi.common.resource.TextFragment;

public final class CodeMatches {
    public static int NO_MATCH = Integer.MIN_VALUE;
    public static int ADDED_MATCH = -2147483647;
    public static CodeMatches NO_CODES = new CodeMatches(0, 0);
    public static CodeMatches SAME_CODES = new CodeMatches(0, 0);
    private final int[] fromMatches;
    private final int[] toMatches;
    private final boolean[] toIsolated;
    private final boolean[] fromIsolated;

    private CodeMatches(int fromSize, int toSize) {
        this.fromMatches = new int[fromSize];
        this.toMatches = new int[toSize];
        this.toIsolated = new boolean[toSize];
        this.fromIsolated = new boolean[fromSize];
        Arrays.fill(this.fromMatches, NO_MATCH);
        Arrays.fill(this.toMatches, NO_MATCH);
        Arrays.fill(this.toIsolated, false);
        Arrays.fill(this.fromIsolated, false);
    }

    public CodeMatches(TextFragment from, TextFragment to) {
        this(from.codes.size(), to.codes.size());
        int index;
        int i;
        for (i = 0; i < from.length(); ++i) {
            switch (from.charAt(i)) {
                case '\ue103': {
                    index = TextFragment.toIndex(from.charAt(i + 1));
                    this.fromIsolated[index] = true;
                }
            }
        }
        for (i = 0; i < to.length(); ++i) {
            switch (to.charAt(i)) {
                case '\ue103': {
                    index = TextFragment.toIndex(to.charAt(i + 1));
                    this.toIsolated[index] = true;
                }
            }
        }
    }

    public int[] getFromMatches() {
        return this.fromMatches;
    }

    public int[] getToMatches() {
        return this.toMatches;
    }

    public void setFromMatch(int index, int id) {
        this.fromMatches[index] = id;
    }

    public void setToMatch(int index, int id) {
        this.toMatches[index] = id;
    }

    public int getToMatchIndex(int toIndex) {
        if (this.isToMatch(toIndex)) {
            return this.toMatches[toIndex];
        }
        return NO_MATCH;
    }

    public boolean isToMatch(int index) {
        return this.toMatches[index] != NO_MATCH;
    }

    public boolean isToIsolated(int index) {
        return this.toIsolated[index];
    }

    public boolean isFromIsolated(int index) {
        return this.fromIsolated[index];
    }

    public boolean hasFromMismatch() {
        for (int m : this.fromMatches) {
            if (m != NO_MATCH) continue;
            return true;
        }
        return false;
    }

    public boolean hasToMismatch() {
        for (int m : this.toMatches) {
            if (m != NO_MATCH) continue;
            return true;
        }
        return false;
    }

    public int getFromMismatchCount() {
        int count = 0;
        for (int m : this.fromMatches) {
            if (m != NO_MATCH) continue;
            ++count;
        }
        return count;
    }

    public int getToMismatchCount() {
        int count = 0;
        for (int m : this.toMatches) {
            if (m != NO_MATCH) continue;
            ++count;
        }
        return count;
    }

    public Iterable<Integer> getFromMismatchIterator() {
        return this.getMismatchIterator(this.fromMatches);
    }

    public Iterable<Integer> getToMismatchIterator() {
        return this.getMismatchIterator(this.toMatches);
    }

    private Iterable<Integer> getMismatchIterator(int[] matches) {
        ArrayList<Integer> mismatchIndexes = new ArrayList<Integer>();
        int i = -1;
        for (int m : matches) {
            ++i;
            if (m != NO_MATCH) continue;
            mismatchIndexes.add(i);
        }
        return mismatchIndexes;
    }
}

