/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.HTMLCharacterEntities;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.encoder.QuoteMode;

public class HtmlEncoder
implements IEncoder {
    public static final String QUOTEMODEDEFINED = "quoteModeDefined";
    public static final String QUOTEMODE = "quoteMode";
    public static final String CONTENT = "content";
    public static final String CHARSET = "charset";
    private CharsetEncoder chsEnc;
    private String lineBreak;
    private String encoding;
    private QuoteMode quoteMode = QuoteMode.NUMERIC_SINGLE_QUOTES;
    private String charsToCER = null;
    private HTMLCharacterEntities entities;
    private IParameters params;

    public HtmlEncoder(String encoding, String lineBreak, QuoteMode quoteMode) {
        this.quoteMode = quoteMode;
        this.setOptions(null, encoding, lineBreak);
    }

    public HtmlEncoder() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.lineBreak = lineBreak;
        this.encoding = encoding;
        this.chsEnc = "utf-8".equals(encoding) || "utf-16".equals(encoding) ? null : Charset.forName(encoding).newEncoder();
        this.params = params;
        if (params != null) {
            int q;
            this.charsToCER = params.getString("escapeCharacters");
            if (params.getBoolean(QUOTEMODEDEFINED) && (q = params.getInteger(QUOTEMODE)) >= 0 && q <= 3) {
                this.quoteMode = QuoteMode.fromValue(params.getInteger(QUOTEMODE));
            }
        }
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        boolean escapeGT = false;
        StringBuilder sbTmp = new StringBuilder(text.length());
        block13: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sbTmp.append("&lt;");
                    continue block13;
                }
                case '>': {
                    if (escapeGT) {
                        sbTmp.append("&gt;");
                        continue block13;
                    }
                    if (i > 0 && text.charAt(i - 1) == ']') {
                        sbTmp.append("&gt;");
                        continue block13;
                    }
                    sbTmp.append('>');
                    continue block13;
                }
                case '&': {
                    sbTmp.append("&amp;");
                    continue block13;
                }
                case '\"': {
                    if (this.quoteMode != QuoteMode.UNESCAPED || EncoderContext.INLINE == context) {
                        sbTmp.append("&quot;");
                        continue block13;
                    }
                    sbTmp.append('\"');
                    continue block13;
                }
                case '\'': {
                    switch (this.quoteMode) {
                        case ALL: {
                            sbTmp.append("&apos;");
                            break;
                        }
                        case NUMERIC_SINGLE_QUOTES: {
                            sbTmp.append("&#39;");
                            break;
                        }
                        case UNESCAPED: 
                        case DOUBLE_QUOTES_ONLY: {
                            if (EncoderContext.INLINE == context) {
                                sbTmp.append("&apos;");
                                break;
                            }
                            sbTmp.append(ch);
                        }
                    }
                    continue block13;
                }
                case '\n': {
                    sbTmp.append(this.lineBreak);
                    continue block13;
                }
                default: {
                    if (ch > '\u007f') {
                        if (Character.isHighSurrogate(ch)) {
                            int cp = text.codePointAt(i++);
                            String tmp = new String(Character.toChars(cp));
                            if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                                sbTmp.append(String.format("&#x%x;", cp));
                                continue block13;
                            }
                            sbTmp.append(tmp);
                            continue block13;
                        }
                        String cer = this.checkCER(ch);
                        if (cer != null) {
                            sbTmp.append(cer);
                            continue block13;
                        }
                        if (this.chsEnc != null && !this.chsEnc.canEncode(ch)) {
                            sbTmp.append(String.format("&#x%04x;", ch));
                            continue block13;
                        }
                        sbTmp.append(ch);
                        continue block13;
                    }
                    sbTmp.append(ch);
                }
            }
        }
        return sbTmp.toString();
    }

    private String checkCER(char ch) {
        if (this.charsToCER != null && this.charsToCER.indexOf(ch) > -1) {
            String name;
            if (this.entities == null) {
                this.entities = new HTMLCharacterEntities();
                this.entities.ensureInitialization(false);
            }
            if ((name = this.entities.getName(ch)) == null) {
                return null;
            }
            return "&" + name + ";";
        }
        return null;
    }

    @Override
    public String encode(char value, EncoderContext context) {
        switch (value) {
            case '<': {
                return "&lt;";
            }
            case '\"': {
                if (this.quoteMode != QuoteMode.UNESCAPED || EncoderContext.INLINE == context) {
                    return "&quot;";
                }
                return "\"";
            }
            case '\'': {
                switch (this.quoteMode) {
                    case ALL: {
                        return "&apos;";
                    }
                    case NUMERIC_SINGLE_QUOTES: {
                        return "&#39;";
                    }
                    case UNESCAPED: 
                    case DOUBLE_QUOTES_ONLY: {
                        return EncoderContext.INLINE == context ? "&apos;" : "'";
                    }
                }
            }
            case '&': {
                return "&amp;";
            }
            case '\n': {
                return this.lineBreak;
            }
        }
        if (value > '\u007f') {
            String cer = this.checkCER(value);
            if (cer != null) {
                return cer;
            }
            if (this.chsEnc != null && !this.chsEnc.canEncode(value)) {
                return String.format("&#x%04x;", value);
            }
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        switch (value) {
            case 60: {
                return "&lt;";
            }
            case 34: {
                if (this.quoteMode != QuoteMode.UNESCAPED || EncoderContext.INLINE == context) {
                    return "&quot;";
                }
                return "\"";
            }
            case 39: {
                switch (this.quoteMode) {
                    case ALL: {
                        return "&apos;";
                    }
                    case NUMERIC_SINGLE_QUOTES: {
                        return "&#39;";
                    }
                    case UNESCAPED: 
                    case DOUBLE_QUOTES_ONLY: {
                        return EncoderContext.INLINE == context ? "&apos;" : "'";
                    }
                }
            }
            case 38: {
                return "&amp;";
            }
            case 10: {
                return this.lineBreak;
            }
        }
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                String tmp = new String(Character.toChars(value));
                if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                    return String.format("&#x%x;", value);
                }
                return tmp;
            }
            String cer = this.checkCER((char)value);
            if (cer != null) {
                return cer;
            }
            if (this.chsEnc != null && !this.chsEnc.canEncode((char)value)) {
                return String.format("&#x%04x;", value);
            }
            return String.valueOf((char)value);
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }
}

