/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;

public class IssueAnnotation
extends GenericAnnotation {
    private static final String CODES_SEP = "\u2628";
    private IssueType issueType = IssueType.OTHER;

    public IssueAnnotation() {
        super("its-lqi");
        this.setBoolean("lqiEnabled", true);
    }

    public IssueAnnotation(IssueType issueType, String comment, double severity, String segId, int srcStart, int srcEnd, int trgStart, int trgEnd, List<Code> codes) {
        this();
        this.setIssueType(issueType);
        this.setString("lqiComment", comment);
        this.setSeverity(severity);
        this.setSourcePosition(srcStart, srcEnd);
        this.setTargetPosition(trgStart, trgEnd);
        this.setString("lqiXSegId", segId);
        this.setCodes(codes);
    }

    public IssueAnnotation(GenericAnnotation ann) {
        super("its-lqi");
        this.setBoolean("lqiEnabled", ann.getBoolean("lqiEnabled"));
        String xtype = ann.getString("lqiXType");
        if (xtype == null) {
            this.setString("lqiType", ann.getString("lqiType"));
        } else {
            this.issueType = IssueType.valueOf(xtype);
            this.setString("lqiType", IssueType.mapToITS(this.issueType));
        }
        this.setComment(ann.getString("lqiComment"));
        this.setSeverity(ann.getDouble("lqiSeverity"));
        this.setProfileRef(ann.getString("lqiProfileRef"));
        this.setSourcePosition(ann.getInteger("lqiXStart"), ann.getInteger("lqiXEnd"));
        this.setTargetPosition(ann.getInteger("lqiXTrgStart"), ann.getInteger("lqiXTrgEnd"));
        this.setString("lqiXSegId", ann.getString("lqiXSegId"));
        this.setString("lqiXCodes", ann.getString("lqiXCodes"));
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public void setIssueType(IssueType issueType) {
        this.issueType = issueType;
        this.setString("lqiXType", issueType.toString());
        this.setString("lqiType", IssueType.mapToITS(issueType));
    }

    public String getITSType() {
        return this.getString("lqiType");
    }

    public void setITSType(String itsType) {
        this.setString("lqiType", itsType);
    }

    public String getSegId() {
        return this.getString("lqiXSegId");
    }

    public void setSegId(String segId) {
        this.setString("lqiXSegId", segId);
    }

    public int getSourceStart() {
        Integer res = this.getInteger("lqiXStart");
        return res == null ? 0 : res;
    }

    public int getSourceEnd() {
        Integer res = this.getInteger("lqiXEnd");
        return res == null ? -1 : res;
    }

    public void setSourcePosition(Integer start, Integer end) {
        this.setInteger("lqiXStart", start == null ? 0 : start);
        this.setInteger("lqiXEnd", end == null ? -1 : end);
    }

    public int getTargetStart() {
        Integer res = this.getInteger("lqiXTrgStart");
        return res == null ? 0 : res;
    }

    public int getTargetEnd() {
        Integer res = this.getInteger("lqiXTrgEnd");
        return res == null ? -1 : res;
    }

    public void setTargetPosition(Integer start, Integer end) {
        this.setInteger("lqiXTrgStart", start == null ? 0 : start);
        this.setInteger("lqiXTrgEnd", end == null ? -1 : end);
    }

    public boolean getEnabled() {
        Boolean res = this.getBoolean("lqiEnabled");
        return res == null ? false : res;
    }

    public void setEnabled(boolean enabled) {
        this.setBoolean("lqiEnabled", enabled);
    }

    public double getSeverity() {
        Double res = this.getDouble("lqiSeverity");
        return res == null ? 0.0 : res;
    }

    public void setSeverity(double severity) {
        if (severity < 0.0 || severity > 100.0) {
            throw new InvalidParameterException("Invalid severity value.");
        }
        this.setDouble("lqiSeverity", severity);
    }

    public String getComment() {
        return this.getString("lqiComment");
    }

    public void setComment(String comment) {
        this.setString("lqiComment", comment);
    }

    public String getCodes() {
        return this.getString("lqiXCodes");
    }

    public String[] getCodesAsArray() {
        String tmp = this.getString("lqiXCodes");
        if (tmp == null) {
            return null;
        }
        return tmp.split(CODES_SEP, 0);
    }

    public List<Code> getCodesAsList() {
        String tmp = this.getString("lqiXCodes");
        if (tmp == null) {
            return null;
        }
        String[] dataArray = tmp.split(CODES_SEP, 0);
        ArrayList<Code> list = new ArrayList<Code>();
        for (String data : dataArray) {
            list.add(new Code(TextFragment.TagType.PLACEHOLDER, "none", data));
        }
        return list;
    }

    public void setCodes(List<Code> codes) {
        if (Util.isEmpty(codes)) {
            this.setString("lqiXCodes", null);
        } else {
            StringBuilder values = new StringBuilder();
            for (Code code : codes) {
                values.append(CODES_SEP);
                values.append(code.getData());
            }
            this.setString("lqiXCodes", values.toString().substring(1));
        }
    }

    public void setCodes(String codes) {
        this.setString("lqiXCodes", codes);
    }

    public String getProfileRef() {
        return this.getString("lqiProfileRef");
    }

    public void setProfileRef(String profileRef) {
        this.setString("lqiProfileRef", profileRef);
    }

    @Override
    public String toString() {
        this.setString("lqiXIssueType", this.issueType.toString());
        return super.toString();
    }

    @Override
    public void fromString(String storage) {
        super.fromString(storage);
        this.issueType = IssueType.valueOf(this.getString("lqiXIssueType"));
        this.setString("lqiXIssueType", null);
    }
}

