/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.annotation.IAnnotation;

public class Annotations
implements Iterable<IAnnotation> {
    private ConcurrentHashMap<Class<? extends IAnnotation>, IAnnotation> annotations = new ConcurrentHashMap();

    public <T extends IAnnotation> void set(T annotation) {
        if (annotation != null) {
            this.annotations.put(annotation.getClass(), annotation);
        }
    }

    public <A extends IAnnotation> A get(Class<A> annotationType) {
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    public void clear() {
        this.annotations.clear();
    }

    public <A extends IAnnotation> A remove(Class<A> annotationType) {
        return (A)((IAnnotation)annotationType.cast(this.annotations.remove(annotationType)));
    }

    public Annotations clone() {
        Annotations anns = new Annotations();
        for (IAnnotation ann : this.annotations.values()) {
            anns.set(ann);
        }
        return anns;
    }

    @Override
    public Iterator<IAnnotation> iterator() {
        return this.annotations.values().iterator();
    }

    public Set<Class<? extends IAnnotation>> getAnnotationsTypes() {
        return this.annotations.keySet();
    }

    public boolean isEmpty() {
        return this.annotations.entrySet().isEmpty();
    }
}

