/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

class VariableResolver
implements XPathVariableResolver {
    private SortedMap<QName, String> table;

    VariableResolver() {
    }

    @Override
    public Object resolveVariable(QName qName) {
        if (this.table == null) {
            return null;
        }
        return this.table.get(qName);
    }

    public void add(QName qName, String value, boolean overwrite) {
        if (!overwrite && this.table != null && this.table.containsKey(qName)) {
            return;
        }
        if (this.table == null) {
            this.table = new TreeMap<QName, String>(new QNameReverseComparator());
        }
        this.table.put(qName, value);
    }

    public String replaceVariables(String xpath) {
        if (this.table == null) {
            return xpath;
        }
        for (Map.Entry<QName, String> e : this.table.entrySet()) {
            xpath = xpath.replace("$" + e.getKey().toString(), this.quote(e.getValue()));
        }
        return xpath;
    }

    private String quote(String text) {
        if (text.indexOf(39) != -1) {
            if (text.indexOf(34) != -1) {
                return "'" + text + "'";
            }
            return "\"" + text + "\"";
        }
        return "'" + text + "'";
    }

    static class QNameReverseComparator
    implements Comparator<QName> {
        QNameReverseComparator() {
        }

        @Override
        public int compare(QName arg0, QName arg1) {
            return arg1.toString().compareTo(arg0.toString());
        }
    }
}

