/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.document;

import java.util.Iterator;
import java.util.Stack;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.document.EventIterator;
import net.sf.okapi.lib.xliff2.document.IGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.IWithGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.WithGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.URIContext;

public class GroupNode
extends WithGroupOrUnitNode
implements IGroupOrUnitNode,
IWithGroupOrUnitNode {
    private GroupNode parent;
    private StartGroupData data;

    public GroupNode(GroupNode parent, StartGroupData data) {
        if (data == null) {
            throw new InvalidParameterException("The data associated with the new group node must not be null.");
        }
        this.parent = parent;
        this.data = data;
    }

    public StartGroupData get() {
        return this.data;
    }

    @Override
    public boolean isUnit() {
        return false;
    }

    public GroupNode getParent() {
        return this.parent;
    }

    public Iterator<Event> createEventIterator(Stack<URIContext> uriContext) {
        EventIterator ei = new EventIterator(){
            private Iterator<IGroupOrUnitNode> topIter;
            private Stack<Iterator<IGroupOrUnitNode>> groups;
            private Iterator<IGroupOrUnitNode> groupIter;
            private int state;
            {
                this.topIter = GroupNode.this.createGroupOrUnitIterator();
                this.groups = new Stack();
                this.groupIter = null;
                this.state = 0;
            }

            @Override
            public boolean hasNext() {
                switch (this.state) {
                    case 0: {
                        return true;
                    }
                    case -1: {
                        return false;
                    }
                }
                if (this.groupIter != null) {
                    if (this.groupIter.hasNext()) {
                        return true;
                    }
                    this.groups.pop();
                    this.state = 2;
                    this.groupIter = this.groups.isEmpty() ? null : this.groups.peek();
                    return true;
                }
                if (this.topIter.hasNext()) {
                    return true;
                }
                this.state = 3;
                return true;
            }

            @Override
            public Event next() {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                        ((URIContext)this.uriContext.peek()).setGroupId(GroupNode.this.data.getId());
                        return new Event(EventType.START_GROUP, (URIContext)this.uriContext.peek(), GroupNode.this.data);
                    }
                    case 2: {
                        this.state = 1;
                        this.uriContext.pop();
                        return new Event(EventType.END_GROUP, null);
                    }
                    case 3: {
                        this.state = -1;
                        this.uriContext.pop();
                        return new Event(EventType.END_GROUP, null);
                    }
                }
                if (this.groupIter != null) {
                    IGroupOrUnitNode node = this.groupIter.next();
                    if (node.isUnit()) {
                        this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                        ((URIContext)this.uriContext.peek()).setUnitId(((UnitNode)node).get().getId());
                        Event event = new Event(EventType.TEXT_UNIT, (URIContext)this.uriContext.peek(), ((UnitNode)node).get());
                        this.uriContext.pop();
                        return event;
                    }
                    GroupNode gn = (GroupNode)node;
                    this.groups.push(gn.createGroupOrUnitIterator());
                    this.groupIter = this.groups.peek();
                    this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                    ((URIContext)this.uriContext.peek()).setGroupId(gn.get().getId());
                    return new Event(EventType.START_GROUP, (URIContext)this.uriContext.peek(), gn.get());
                }
                IGroupOrUnitNode node = this.topIter.next();
                if (node.isUnit()) {
                    this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                    ((URIContext)this.uriContext.peek()).setUnitId(((UnitNode)node).get().getId());
                    Event event = new Event(EventType.TEXT_UNIT, (URIContext)this.uriContext.peek(), ((UnitNode)node).get());
                    this.uriContext.pop();
                    return event;
                }
                GroupNode gn = (GroupNode)node;
                this.groups.push(gn.createGroupOrUnitIterator());
                this.groupIter = this.groups.peek();
                this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                ((URIContext)this.uriContext.peek()).setGroupId(gn.get().getId());
                return new Event(EventType.START_GROUP, (URIContext)this.uriContext.peek(), gn.get());
            }
        };
        ei.setURIContext(uriContext);
        return ei;
    }
}

