/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class NSContext
implements NamespaceContext,
Cloneable {
    private Hashtable<String, String> table = new Hashtable();

    public NSContext() {
    }

    public NSContext(String prefix, String uri) {
        this();
        this.put(prefix, uri);
    }

    public String toString() {
        return this.table.toString();
    }

    public NSContext clone() {
        NSContext copy = new NSContext();
        copy.table = (Hashtable)this.table.clone();
        return copy;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.table.containsKey(prefix)) {
            return this.table.get(prefix);
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return "";
    }

    @Override
    public String getPrefix(String uri) {
        Enumeration<String> E = this.table.keys();
        while (E.hasMoreElements()) {
            String key = E.nextElement();
            if (!this.table.get(key).equals(uri)) continue;
            return key;
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return Collections.singletonList("xml").iterator();
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return Collections.singletonList("xmlns").iterator();
        }
        ArrayList<String> res = new ArrayList<String>();
        Enumeration<String> e = this.table.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (!this.table.get(key).equals(uri)) continue;
            res.add(key);
        }
        return Collections.unmodifiableList(res).iterator();
    }

    public void put(String prefix, String uri) {
        this.table.put(prefix, uri);
    }

    public boolean containsPair(String prefix, String uri) {
        Iterator<String> iter = this.getPrefixes(uri);
        while (iter.hasNext()) {
            if (!iter.next().equals(prefix)) continue;
            return true;
        }
        return false;
    }
}

