/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.scorer;

import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;

public class TmFuzzyScorer
extends Scorer {
    private static float ROUGH_CUTOFF = 0.5f;
    private List<Term> terms;
    private IndexReader reader;
    private float threshold;
    private float score;
    private int currentDoc;
    private int roughThresholdFreq;
    private DocIdSetIterator docPointerIterator;
    private TIntIntHashMap scoredDocs;
    private int uniqueTermSize;
    private String termCountField;

    public TmFuzzyScorer(float threshold, Weight weight, List<Term> terms, IndexReader reader, String termCountField) throws IOException {
        super(weight);
        this.reader = reader;
        this.threshold = threshold;
        this.terms = terms;
        this.termCountField = termCountField;
        this.scoredDocs = new TIntIntHashMap();
        this.currentDoc = -1;
    }

    private void calculateScores() throws IOException {
        FixedBitSet docPointers = new FixedBitSet(this.reader.maxDoc());
        LinkedList<Term> uniqueTerms = new LinkedList<Term>(new LinkedHashSet<Term>(this.terms));
        this.uniqueTermSize = uniqueTerms.size();
        this.roughThresholdFreq = (int)((float)this.uniqueTermSize * ROUGH_CUTOFF);
        for (Term term : uniqueTerms) {
            for (LeafReaderContext lrx : this.reader.leaves()) {
                int docId;
                LeafReader lr = lrx.reader();
                PostingsEnum posts = lr.postings(term, 8);
                if (posts == null) continue;
                while ((docId = posts.nextDoc()) != Integer.MAX_VALUE) {
                    int f = this.scoredDocs.adjustOrPutValue(docId, 1, 1);
                    if (f <= this.roughThresholdFreq) continue;
                    docPointers.set(docId);
                }
            }
        }
        if (docPointers.cardinality() > 0) {
            this.docPointerIterator = new BitSetIterator((BitSet)docPointers, 1L);
        }
    }

    public float score() throws IOException {
        return this.score;
    }

    private float calculateScore() throws IOException {
        this.score = 2.0f * (float)this.scoredDocs.get(this.currentDoc) / (float)(this.reader.getTermVector(this.currentDoc, this.termCountField).size() + (long)this.uniqueTermSize) * 100.0f;
        return this.score;
    }

    public int docID() {
        return this.currentDoc;
    }

    public DocIdSetIterator iterator() {
        return new DocIdSetIterator(){

            public int docID() {
                return TmFuzzyScorer.this.currentDoc;
            }

            public int nextDoc() throws IOException {
                if (TmFuzzyScorer.this.docPointerIterator == null) {
                    TmFuzzyScorer.this.calculateScores();
                    if (TmFuzzyScorer.this.docPointerIterator == null) {
                        TmFuzzyScorer.this.currentDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
                do {
                    TmFuzzyScorer.this.currentDoc = TmFuzzyScorer.this.docPointerIterator.nextDoc();
                    if (TmFuzzyScorer.this.currentDoc != Integer.MAX_VALUE) continue;
                    return TmFuzzyScorer.this.currentDoc;
                } while (!(TmFuzzyScorer.this.calculateScore() >= TmFuzzyScorer.this.threshold));
                return TmFuzzyScorer.this.currentDoc;
            }

            public int advance(int target) throws IOException {
                if (target == Integer.MAX_VALUE) {
                    TmFuzzyScorer.this.currentDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                while ((TmFuzzyScorer.this.currentDoc = this.nextDoc()) < target) {
                }
                return TmFuzzyScorer.this.currentDoc;
            }

            public long cost() {
                return 0L;
            }
        };
    }

    public float getMaxScore(int i) throws IOException {
        return Float.POSITIVE_INFINITY;
    }
}

