/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.analysis;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.pattern.PatternReplaceFilter;

public final class NgramAnalyzer
extends Analyzer {
    public static final int MAX_INPUT_SIZE = 4096;
    private int ngramLength;

    public NgramAnalyzer(int ngramLength) {
        if (ngramLength <= 0) {
            throw new IllegalArgumentException("'ngramLength' cannot be less than 0");
        }
        this.ngramLength = ngramLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        KeywordTokenizer source = new KeywordTokenizer(4096);
        LengthFilter result = new LengthFilter((TokenStream)new NGramTokenFilter((TokenStream)new LowerCaseFilter((TokenStream)new PatternReplaceFilter((TokenStream)source, Pattern.compile("\\s+"), " ", true)), this.ngramLength, this.ngramLength, true), 1, this.ngramLength);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }
}

