/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeMatches;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextPartComparator;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitMerger
implements ITextUnitMerger {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private LocaleId trgLoc;
    private Parameters params = new Parameters();
    private String translatedTuId;

    @Override
    public ITextUnit mergeTargets(ITextUnit tuFromSkel, ITextUnit tuFromTran) {
        String sourceFromTranslated;
        String originalSource;
        if (tuFromSkel == null || tuFromTran == null) {
            this.LOGGER.warn("Null TextUnit in TextUnitMerger.");
            return tuFromSkel;
        }
        this.translatedTuId = tuFromTran.getId();
        if (!tuFromSkel.getId().equals(tuFromTran.getId())) {
            String s = String.format("Text Unit id mismatch during merger: Original id=\"%s\" target id=\"%s\"", tuFromSkel.getId(), tuFromTran.getId());
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentIdException()) {
                throw new OkapiMergeException(s);
            }
        }
        if (!(originalSource = StringUtil.removeWhiteSpace(tuFromSkel.getSource().createJoinedContent().getText())).equals(sourceFromTranslated = StringUtil.removeWhiteSpace(tuFromTran.getSource().createJoinedContent().getText()))) {
            String s = String.format("Text Unit source mismatch during merge: Original id=\"%s\" target id=\"%s\"\nOriginal Source=\"%s\"\nTranslated Source=\"%s\"", tuFromSkel.getId(), tuFromTran.getId(), originalSource, sourceFromTranslated);
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentSourceException()) {
                throw new OkapiMergeException(s);
            }
        }
        if (!tuFromTran.hasTarget(this.trgLoc) || tuFromTran.getTarget(this.trgLoc) == null) {
            if (tuFromSkel.getSource().hasText()) {
                this.LOGGER.warn("No translation found for TU id='{}'. Using source as translation.", (Object)tuFromTran.getId());
            }
            return tuFromSkel;
        }
        boolean isTransApproved = false;
        Property traProp = tuFromTran.getTarget(this.trgLoc).getProperty("approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (this.params != null && this.params.isApprovedOnly() && !isTransApproved) {
            this.LOGGER.warn("Item id='{}': Target is not approved. Skipping. Using source as translation.", (Object)tuFromSkel.getId());
            return tuFromSkel;
        }
        ITextUnit mergedTextUnit = tuFromSkel.clone();
        mergedTextUnit.setSource(tuFromTran.getSource().clone());
        mergedTextUnit.setTarget(this.trgLoc, tuFromTran.getTarget(this.trgLoc).clone());
        IWithProperties.copy(tuFromSkel.getSource(), mergedTextUnit.getSource());
        IWithAnnotations.copy(tuFromSkel.getSource(), mergedTextUnit.getSource());
        IWithProperties.copy(tuFromSkel.getTarget(this.trgLoc), mergedTextUnit.getTarget(this.trgLoc));
        IWithAnnotations.copy(tuFromSkel.getTarget(this.trgLoc), mergedTextUnit.getTarget(this.trgLoc));
        boolean mergeAsSegments = MimeTypeMapper.isSegmentationSupported(tuFromSkel.getMimeType());
        List<Range> srcRanges = null;
        List<Range> trgRanges = null;
        if (mergeAsSegments) {
            srcRanges = mergedTextUnit.getSource().getSegments().getRanges();
            trgRanges = mergedTextUnit.getTarget(this.trgLoc).getSegments().getRanges();
        }
        for (TextPart tp : mergedTextUnit.getSource().getSegments()) {
            if (!TextUnitUtil.hasMergedCode(tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes(tp.text);
        }
        for (TextPart tp : mergedTextUnit.getTarget(this.trgLoc).getSegments()) {
            if (!TextUnitUtil.hasMergedCode(tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes(tp.text);
        }
        if (!mergedTextUnit.getSource().contentIsOneSegment()) {
            mergedTextUnit.getSource().getSegments().joinAll();
        }
        if (!mergedTextUnit.getTarget(this.trgLoc).contentIsOneSegment()) {
            mergedTextUnit.getTarget(this.trgLoc).getSegments().joinAll();
        }
        this.removeOuterData(mergedTextUnit.getSource().getFirstContent().getCodes());
        this.removeOuterData(mergedTextUnit.getTarget(this.trgLoc).getFirstContent().getCodes());
        TextContainer skelContent = tuFromSkel.getSource();
        if (!tuFromSkel.getSource().contentIsOneSegment()) {
            skelContent = tuFromSkel.getSource().clone();
            skelContent.joinAll();
        }
        this.copyCodeMetadata(skelContent.getFirstContent(), mergedTextUnit.getSource().getFirstContent());
        this.copyCodeMetadata(mergedTextUnit.getSource().getFirstContent(), mergedTextUnit.getTarget(this.trgLoc).getFirstContent());
        if (mergeAsSegments) {
            if (!Util.isEmpty(srcRanges)) {
                mergedTextUnit.getSource().getSegments().create(srcRanges, true);
            }
            if (!Util.isEmpty(trgRanges)) {
                mergedTextUnit.getTarget(this.trgLoc).getSegments().create(trgRanges, true);
            }
        }
        if (mergedTextUnit.getSource().getSegments().count() != mergedTextUnit.getTarget(this.trgLoc).getSegments().count()) {
            this.LOGGER.warn("Item id='{}': Different number of source and target segments.", (Object)tuFromTran.getId());
        }
        if (mergeAsSegments) {
            if (!Util.isEmpty(srcRanges)) {
                mergedTextUnit.getSource().setHasBeenSegmentedFlag(tuFromTran.getSource().hasBeenSegmented());
                this.copyTextPartMetadata(tuFromSkel.getSource().getParts(), mergedTextUnit.getSource().getParts(), mergedTextUnit.getId());
            }
            if (tuFromSkel.hasTarget(this.trgLoc) && !Util.isEmpty(trgRanges)) {
                mergedTextUnit.getTarget(this.trgLoc).setHasBeenSegmentedFlag(tuFromTran.getTarget(this.trgLoc).hasBeenSegmented());
                this.copyTextPartMetadata(tuFromSkel.getTarget(this.trgLoc).getParts(), mergedTextUnit.getTarget(this.trgLoc).getParts(), mergedTextUnit.getId());
            }
        }
        return mergedTextUnit;
    }

    @Override
    public void copyTextPartMetadata(List<TextPart> from, List<TextPart> to, String id) {
        if (Util.isEmpty(from) && Util.isEmpty(to)) {
            return;
        }
        TextPartComparator cmp = new TextPartComparator();
        boolean[] matched = new boolean[to.size()];
        Arrays.fill(matched, false);
        for (TextPart origPart : from) {
            TextPart tp = Util.findMatch(origPart, to, matched, cmp);
            if (tp == null && to.size() == 1) {
                tp = to.get(0);
            }
            if (tp == null) {
                if (this.hasMeta(origPart)) {
                    this.LOGGER.error("TextUnit id='{}' TextPart id='{}': Can't find matching TextPart in merged text unit. Cannot copy TextPart properties/annotations. Merged file may differ from original", (Object)id, (Object)origPart.id);
                    continue;
                }
                this.LOGGER.warn("TextUnit id='{}' TextPart id='{}': Can't find matching TextPart in merged text unit. Possible segmentation changes in the translated file", (Object)id, (Object)origPart.id);
                continue;
            }
            tp.id = origPart.id;
            tp.originalId = origPart.originalId;
            tp.whitespaceStrategy = origPart.whitespaceStrategy;
            IWithProperties.copy(origPart, tp);
            IWithAnnotations.copy(origPart, tp);
        }
    }

    private <T extends TextPart> boolean hasMeta(T p) {
        boolean hasProps = !p.getPropertyNames().isEmpty();
        boolean hasAnnotations = p.getAnnotations().iterator().hasNext();
        return hasProps || hasAnnotations || p.id != null;
    }

    @Override
    public void copyCodeMetadata(TextFragment from, TextFragment to) {
        CodeMatches m = TextFragmentUtil.alignAndCopyCodeMetadata(from, to);
        if (m.hasFromMismatch() || m.hasToMismatch()) {
            TextFragmentUtil.logCodeMismatchErrors(m, from, to, this.translatedTuId);
            if (this.params.isThrowCodeException()) {
                throw new OkapiMergeException("TextUnit Merge Error for TU: " + this.translatedTuId);
            }
        }
    }

    private void removeOuterData(List<Code> codes) {
        for (Code c : codes) {
            c.setOuterData(null);
        }
    }

    @Override
    public void setTargetLocale(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(Parameters params) {
        this.params = params;
    }
}

