/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml.parser;

import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.filters.yaml.parser.Line;
import net.sf.okapi.filters.yaml.parser.YamlScalarTypes;

public class IndentedBlock {
    public List<Line> lines;
    public int firstIndent = -1;
    public YamlScalarTypes type = YamlScalarTypes.UNKNOWN;

    public IndentedBlock() {
        this.lines = new LinkedList<Line>();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public void addLine(Line line) {
        if (line != null && !line.isEmpty()) {
            if (!line.isSkeleton && this.firstIndent == -1) {
                this.firstIndent = line.indent;
            }
            this.lines.add(line);
        }
    }

    public List<Line> getTranslatableStrings() {
        if (this.lines.isEmpty()) {
            return null;
        }
        LinkedList<Line> indentedLines = new LinkedList<Line>();
        LinkedList<Line> linesWithoutThroway = new LinkedList<Line>();
        StringBuilder t = new StringBuilder();
        for (Line l : this.lines) {
            if (this.type != YamlScalarTypes.LITERAL && l.isThrowAway) continue;
            linesWithoutThroway.add(l);
        }
        Line lastLine = (Line)linesWithoutThroway.remove(linesWithoutThroway.size() - 1);
        String last = this.adjustWhiteSpace(lastLine.line, lastLine.indent - this.firstIndent, true, null);
        int i = -1;
        int size = linesWithoutThroway.size();
        for (Line l : linesWithoutThroway) {
            ++i;
            if (l.isSkeleton) {
                if (t.length() > 0) {
                    indentedLines.add(new Line(t.toString(), false));
                    t.setLength(0);
                }
                indentedLines.add(l);
                continue;
            }
            Line next = null;
            if (i < size - 1) {
                next = (Line)linesWithoutThroway.get(i + 1);
            }
            t.append(this.adjustWhiteSpace(l.line, l.indent - this.firstIndent, false, next));
        }
        indentedLines.add(new Line(t.toString() + last, false));
        return indentedLines;
    }

    private String adjustWhiteSpace(String line, int indent, boolean lastLine, Line next) {
        switch (this.type) {
            case PLAIN: {
                line = Util.trimEnd(line, "\r\n");
                if (lastLine) {
                    return line;
                }
                if (next != null && next.isSkeleton) {
                    return line;
                }
                line = line + " ";
                return line;
            }
            case FOLDED: {
                StringBuilder t = new StringBuilder(line);
                t = new StringBuilder(line);
                if (next != null && next.isSkeleton) {
                    return line;
                }
                if (!lastLine) {
                    t.append(" ");
                }
                return t.toString();
            }
            case LITERAL: {
                StringBuilder t = new StringBuilder(line);
                return t.toString();
            }
        }
        return line;
    }

    public String getOriginalString() {
        StringBuilder s = new StringBuilder();
        for (Line l : this.lines) {
            s.append(l.line);
        }
        return s.toString();
    }

    public String toString() {
        return this.lines.toString();
    }
}

