/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

public enum SdlXliffConfLevel {
    APPROVED_SIGN_OFF("ApprovedSignOff", "x-sdl-ApprovedSignOff"),
    APPROVED_TRANSLATION("ApprovedTranslation", "x-sdl-ApprovedTranslation"),
    DRAFT("Draft", "x-sdl-Draft"),
    REJECTED_SIGN_OFF("RejectedSignOff", "x-sdl-RejectedSignOff"),
    REJECTED_TRANSLATION("RejectedTranslation", "x-sdl-RejectedTranslation"),
    TRANSLATED("Translated", "x-sdl-Translated"),
    UNSPECIFIED("Unspecified", "x-sdl-Unspecified");

    private final String confValue;
    private final String stateValue;

    private SdlXliffConfLevel(String confValue, String stateValue) {
        this.confValue = confValue;
        this.stateValue = stateValue;
    }

    public String getConfValue() {
        return this.confValue;
    }

    public String getStateValue() {
        return this.stateValue;
    }

    public static boolean isValidConfValue(String confValue) {
        for (SdlXliffConfLevel confLevel : SdlXliffConfLevel.values()) {
            if (!confLevel.confValue.equals(confValue)) continue;
            return true;
        }
        return false;
    }

    public static SdlXliffConfLevel fromConfValue(String confValue) {
        for (SdlXliffConfLevel confLevel : SdlXliffConfLevel.values()) {
            if (!confLevel.confValue.equals(confValue)) continue;
            return confLevel;
        }
        throw new IllegalArgumentException("No valid conf level for conf value: " + confValue);
    }

    public static boolean isValidStateValue(String stateValue) {
        for (SdlXliffConfLevel confLevel : SdlXliffConfLevel.values()) {
            if (!confLevel.stateValue.equals(stateValue)) continue;
            return true;
        }
        return false;
    }

    public static SdlXliffConfLevel fromStateValue(String stateValue) {
        for (SdlXliffConfLevel confLevel : SdlXliffConfLevel.values()) {
            if (!confLevel.stateValue.equals(stateValue)) continue;
            return confLevel;
        }
        throw new IllegalArgumentException("No valid conf level for state value: " + stateValue);
    }
}

