/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.resource.CodeTypeBuilder;
import net.sf.okapi.common.resource.ExtendedCodeType;

class CodeTypeFactory {
    private static final Set<String> HYPERLINK_DATA_START_ELEMENT_NAMES = new HashSet<String>();
    private static final String DATA_END_MARKER = ">";
    private static final String DATA_CHUNKS_DELIMITER = " ";
    private static final String NAME_AND_VALUE_DELIMITER = "=";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String STRIKE_THROUGH_DATA_CHUNK_NAME = "strikethrough";
    private static final String SHADOW_DATA_CHUNK_NAME = "shadow";
    private static final String UNDERLINE_DATA_CHUNK_NAME = "underline";
    private static final String HIGHLIGHT_COLOR_DATA_CHUNK_NAME = "highlight";
    private static final String COLOR_DATA_CHUNK_NAME = "color";
    private static final String SUPERSCRIPT_DATA_CHUNK_NAME = "superscript";
    private static final String SUBSCRIPT_DATA_CHUNK_NAME = "subscript";
    private static final String FALSE_VALUE = Boolean.FALSE.toString();
    private static final String NONE_VALUE = "none";
    private static final String NO_STRIKE_VALUE = "nostrike";
    private static final boolean ADD_EXTENDED_CODE_TYPE_PREFIX = true;

    CodeTypeFactory() {
    }

    static String createCodeType(String data, String dataStartElementName) throws XMLStreamException {
        String[] dataChunks;
        CodeTypeBuilder codeTypeBuilder = new CodeTypeBuilder(true);
        if (HYPERLINK_DATA_START_ELEMENT_NAMES.contains(dataStartElementName)) {
            codeTypeBuilder.addType("link");
        }
        for (String dataChunk : dataChunks = CodeTypeFactory.getDataChunks(data, dataStartElementName)) {
            CodeTypeFactory.handleDataChunk(codeTypeBuilder, dataChunk);
        }
        return codeTypeBuilder.build();
    }

    private static String[] getDataChunks(String data, String dataStartElementName) {
        int startDataIndex;
        if (null == dataStartElementName) {
            return new String[0];
        }
        int dataStartElementNameIndex = data.indexOf(dataStartElementName);
        if (-1 == dataStartElementNameIndex) {
            return new String[0];
        }
        int endDataIndex = data.indexOf(DATA_END_MARKER);
        if (-1 == endDataIndex) {
            endDataIndex = data.length() - 1;
        }
        if ((startDataIndex = dataStartElementNameIndex + dataStartElementName.length()) >= endDataIndex) {
            return new String[0];
        }
        String chunksString = data.substring(startDataIndex, endDataIndex);
        return chunksString.split(DATA_CHUNKS_DELIMITER);
    }

    private static void handleDataChunk(CodeTypeBuilder codeTypeBuilder, String dataChunk) {
        String[] nameAndValue = dataChunk.split(NAME_AND_VALUE_DELIMITER);
        if (2 > nameAndValue.length) {
            return;
        }
        String value = CodeTypeFactory.getValue(nameAndValue);
        if (FALSE_VALUE.equals(value.toLowerCase()) || NONE_VALUE.equals(value.toLowerCase())) {
            return;
        }
        switch (nameAndValue[0]) {
            case "bold": {
                codeTypeBuilder.addType("bold");
                break;
            }
            case "italic": {
                codeTypeBuilder.addType("italic");
                break;
            }
            case "strikethrough": {
                if (NO_STRIKE_VALUE.equals(value.toLowerCase())) break;
                codeTypeBuilder.addType(ExtendedCodeType.STRIKE_THROUGH.getValue());
                break;
            }
            case "shadow": {
                codeTypeBuilder.addType(ExtendedCodeType.SHADOW.getValue());
                break;
            }
            case "underline": {
                codeTypeBuilder.addType(ExtendedCodeType.UNDERLINE.getValue(), value);
                break;
            }
            case "highlight": {
                codeTypeBuilder.addType(ExtendedCodeType.HIGHLIGHT.getValue(), value);
                break;
            }
            case "color": {
                codeTypeBuilder.addType(ExtendedCodeType.COLOR.getValue(), value);
                break;
            }
            case "superscript": {
                codeTypeBuilder.addType(ExtendedCodeType.SUPERSCRIPT.getValue());
                break;
            }
            case "subscript": {
                codeTypeBuilder.addType(ExtendedCodeType.SUBSCRIPT.getValue());
            }
        }
    }

    private static String getValue(String[] nameAndValue) {
        if (2 > nameAndValue[1].length()) {
            return nameAndValue[1];
        }
        if (nameAndValue[1].startsWith(DOUBLE_QUOTE) && nameAndValue[1].endsWith(DOUBLE_QUOTE) || nameAndValue[1].startsWith(SINGLE_QUOTE) && nameAndValue[1].endsWith(SINGLE_QUOTE)) {
            return nameAndValue[1].substring(1, nameAndValue[1].length() - 1);
        }
        return nameAndValue[1];
    }

    static {
        HYPERLINK_DATA_START_ELEMENT_NAMES.add("hyperlink");
        HYPERLINK_DATA_START_ELEMENT_NAMES.add("a");
    }
}

