/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ttx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.ttx.Parameters;
import net.sf.okapi.filters.ttx.TTXSkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TTXFilter
implements IFilter {
    public static final String DFSTART_TYPE = "x-df-s";
    public static final String DFEND_TYPE = "x-df-e";
    private static final String MATCHPERCENT = "MatchPercent";
    private static final String ORIGIN = "Origin";
    private static final String TTXNOTEXTCHARS = "\u00a0~`!@#$%^&*()_+=-{[}]|\\:;\"'<,>.?/\u2022\u2013";
    private static final String TARGETLANGUAGE_ATTR = "TargetLanguage";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean hasNext;
    private XMLStreamReader reader;
    private RawDocument input;
    private String docName;
    private int tuId;
    private IdGenerator otherId;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private String srcLangCode;
    private String trgLangCode;
    private String trgDefFont;
    private LinkedList<Event> queue;
    private boolean canceled;
    private GenericSkeleton skel;
    private ITextUnit tu;
    private Parameters params = new Parameters();
    private String encoding;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private StringBuilder buffer;
    private boolean insideContent;
    private TTXSkeletonWriter skelWriter;
    private EncoderManager encoderManager;
    private boolean includeUnsegmentedParts;
    private int numberOfOpenedInternalTags;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_ttx";
    }

    @Override
    public String getDisplayName() {
        return "TTX Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-ttx+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-ttx+xml", this.getClass().getName(), "TTX", "Configuration for Trados TTX documents.", null, ".ttx;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-ttx+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty() && !this.read()) {
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(this.skel);
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.canceled = false;
            this.input = input;
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            if (this.params.getSegmentMode() == 0) {
                String enc = input.getEncoding();
                if (detector.isAutodetected()) {
                    enc = detector.getEncoding();
                }
                this.includeUnsegmentedParts = !this.doesFileContainSegment(input.getInputURI(), enc);
            } else {
                this.includeUnsegmentedParts = this.params.getSegmentMode() == 2;
            }
            this.reader = detector.isAutodetected() ? fact.createXMLStreamReader(input.getStream(), detector.getEncoding()) : fact.createXMLStreamReader(input.getStream());
            String realEnc = this.reader.getCharacterEncodingScheme();
            this.encoding = realEnc != null ? realEnc : input.getEncoding();
            if (this.skelWriter == null) {
                this.skelWriter = new TTXSkeletonWriter();
            }
            this.srcLoc = input.getSourceLocale();
            if (this.srcLoc == null) {
                throw new NullPointerException("Source language not set.");
            }
            this.srcLangCode = this.srcLoc.toString().toUpperCase();
            this.skelWriter.setSourceLanguageCode(this.srcLangCode);
            this.trgLoc = input.getTargetLocale();
            if (this.trgLoc == null) {
                throw new NullPointerException("Target language not set.");
            }
            this.trgLangCode = this.trgLoc.toString().toUpperCase();
            this.skelWriter.setTargetLanguageCode(this.trgLangCode);
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.insideContent = false;
            this.tuId = 0;
            this.otherId = new IdGenerator(null, "o");
            this.hasNext = true;
            this.queue = new LinkedList();
            this.buffer = new StringBuilder();
            this.trgDefFont = null;
            StartDocument startDoc = new StartDocument(this.otherId.createId());
            startDoc.setName(this.docName);
            startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
            startDoc.setLocale(this.srcLoc);
            startDoc.setFilterId(this.getName());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType("application/x-ttx+xml");
            startDoc.setMimeType("application/x-ttx+xml");
            startDoc.setMultilingual(true);
            startDoc.setLineBreak(this.lineBreak);
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
            this.skel = new GenericSkeleton();
            startDoc.setProperty(new Property("encoding", this.encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>");
            startDoc.setSkeleton(this.skel);
            this.skelWriter.processStartDocument(this.trgLoc, this.encoding, null, this.encoderManager, startDoc);
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        if (this.skelWriter == null) {
            this.skelWriter = new TTXSkeletonWriter();
        }
        return this.skelWriter;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private boolean whitespacesOnly(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean read() throws XMLStreamException {
        try {
            this.skel = new GenericSkeleton();
            this.buffer.setLength(0);
            block13: while (true) {
                switch (this.reader.getEventType()) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if ("Tu".equals(name) || "ut".equals(name) || "df".equals(name)) {
                            if (this.processTextUnit(name)) {
                                return true;
                            }
                            if (this.reader.getEventType() != 1) continue block13;
                            this.buildStartElement(true);
                            name = this.reader.getLocalName();
                            this.storeUntilEndElement(name);
                            continue block13;
                        }
                        if ("UserSettings".equals(name)) {
                            this.processUserSettings();
                            break;
                        }
                        if ("Raw".equals(name)) {
                            this.insideContent = true;
                            this.buildStartElement(true);
                            break;
                        }
                        this.buildStartElement(true);
                        break;
                    }
                    case 2: {
                        this.buildEndElement(true);
                        break;
                    }
                    case 6: {
                        this.skel.append(this.reader.getText().replace("\n", this.lineBreak));
                        break;
                    }
                    case 4: 
                    case 12: {
                        if (this.insideContent && !this.whitespacesOnly(this.reader.getText())) {
                            if (!this.processTextUnit(null)) continue block13;
                            return true;
                        }
                        this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, true, null));
                        break;
                    }
                    case 5: {
                        this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                        break;
                    }
                    case 3: {
                        this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                }
                if (!this.reader.hasNext()) break;
                this.reader.next();
            }
            return false;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading TTX.\n" + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processTextUnit(String startTag) {
        try {
            boolean changeToSkel;
            TextFragment inter;
            this.createDocumentPartIfNeeded();
            boolean inTarget = false;
            this.tu = new TextUnit(null);
            TextContainer srcCont = this.tu.getSource();
            ArrayList<TextFragment> trgFragments = new ArrayList<TextFragment>();
            ArrayList<AltTranslation> altTranslations = new ArrayList<AltTranslation>();
            TextFragment srcSegFrag = null;
            TextFragment trgSegFrag = null;
            AltTranslation altTrans = null;
            TextFragment current = inter = new TextFragment();
            boolean returnValueAfterTextUnitDone = true;
            StringBuilder movedCodes = new StringBuilder();
            boolean moveToNext = false;
            int dfCount = 0;
            boolean changeFirst = false;
            boolean done = false;
            boolean inTU = false;
            String lastDFOpen = "";
            String crumbs = "";
            boolean hasOriginalSeg = false;
            this.numberOfOpenedInternalTags = 0;
            while (!done) {
                if (moveToNext) {
                    this.reader.next();
                } else {
                    moveToNext = true;
                }
                block2 : switch (this.reader.getEventType()) {
                    case 4: 
                    case 6: 
                    case 12: {
                        current.append(this.reader.getText());
                        break;
                    }
                    case 1: {
                        String tmp;
                        String name = this.reader.getLocalName();
                        if (!inTU && name.equals("ut")) {
                            if (!this.isInline(name) && !this.isConvertibleToInline()) {
                                done = true;
                                returnValueAfterTextUnitDone = false;
                                break;
                            }
                        } else {
                            if (name.equals("Tu")) {
                                inTU = true;
                                inTarget = false;
                                srcSegFrag = new TextFragment();
                                trgSegFrag = null;
                                altTrans = null;
                                if (!inter.isEmpty()) {
                                    if (this.includeUnsegmentedParts && this.hasText(inter.getCodedText())) {
                                        this.addSegment(inter, srcCont, trgFragments, altTranslations, dfCount, crumbs, movedCodes);
                                    } else {
                                        changeFirst = srcCont.isEmpty();
                                        srcCont.append(inter);
                                    }
                                    inter = null;
                                }
                                current = srcSegFrag;
                                tmp = this.reader.getAttributeValue(null, MATCHPERCENT);
                                String origin = this.reader.getAttributeValue(null, ORIGIN);
                                if (tmp == null && origin == null) break;
                                int value = 0;
                                if (tmp != null) {
                                    try {
                                        value = Integer.valueOf(tmp);
                                    }
                                    catch (Throwable e) {
                                        this.logger.warn("Unexpected value in {} attribute ({})", (Object)MATCHPERCENT, (Object)tmp);
                                    }
                                }
                                if (value <= 0) break;
                                MatchType matchType = MatchType.FUZZY;
                                if (value > 100 && origin != null && origin.equalsIgnoreCase("xtranslate")) {
                                    matchType = MatchType.EXACT_LOCAL_CONTEXT;
                                } else if (value > 99) {
                                    matchType = MatchType.EXACT;
                                }
                                altTrans = new AltTranslation(this.srcLoc, this.trgLoc, null, null, null, matchType, value, origin == null ? "SourceDoc" : origin, value, QueryResult.QUALITY_UNDEFINED);
                                break;
                            }
                            if (name.equals("Tuv")) {
                                hasOriginalSeg = true;
                                tmp = this.reader.getAttributeValue(null, "Lang");
                                if (tmp != null) {
                                    inTarget = this.trgLoc.equalToString(tmp);
                                } else {
                                    this.logger.warn("Attribute Lang is missing in Tuv (after text unit '{}')", (Object)this.tuId);
                                    boolean bl = inTarget = !inTarget;
                                }
                                if (!inTarget) break;
                                current = trgSegFrag = new TextFragment();
                                break;
                            }
                            if (name.equals("df")) {
                                ++dfCount;
                                crumbs = crumbs + "o";
                                Code code = current.append(TextFragment.TagType.PLACEHOLDER, DFSTART_TYPE, "", -1);
                                lastDFOpen = this.buildStartElement(false);
                                code.setOuterData(lastDFOpen);
                                break;
                            }
                        }
                        TextFragment.TagType tagType = TextFragment.TagType.PLACEHOLDER;
                        String type = "ph";
                        int idToUse = -1;
                        String disp = this.reader.getAttributeValue(null, "DisplayText");
                        tmp = this.reader.getAttributeValue(null, "Type");
                        if (tmp != null) {
                            if (tmp.equals("start")) {
                                String leftEdge = this.reader.getAttributeValue(null, "LeftEdge");
                                if (leftEdge == null || !leftEdge.equals("split")) {
                                    tagType = TextFragment.TagType.OPENING;
                                    type = disp != null ? disp : "Xpt";
                                    ++this.numberOfOpenedInternalTags;
                                }
                            } else if (tmp.equals("end")) {
                                tagType = TextFragment.TagType.CLOSING;
                                String string = type = disp != null ? disp : "Xpt";
                                if (0 < this.numberOfOpenedInternalTags) {
                                    --this.numberOfOpenedInternalTags;
                                }
                            }
                        }
                        this.appendCode(tagType, idToUse, name, type, false, current);
                        break;
                    }
                    case 2: {
                        String name;
                        switch (name = this.reader.getLocalName()) {
                            case "Raw": {
                                done = true;
                                break;
                            }
                            case "Body": {
                                done = true;
                                break;
                            }
                            case "df": {
                                --dfCount;
                                crumbs = crumbs + "c";
                                Code code = current.append(TextFragment.TagType.PLACEHOLDER, DFEND_TYPE, "", -1);
                                code.setOuterData(this.buildEndElement(false));
                                break block2;
                            }
                        }
                        if (done || name.equals("Tu")) {
                            if (srcSegFrag != null) {
                                srcCont.getSegments().append(srcSegFrag);
                                if (changeFirst) {
                                    srcCont.changePart(0);
                                    changeFirst = false;
                                }
                                trgFragments.add(trgSegFrag == null ? new TextFragment() : trgSegFrag);
                                if (altTrans != null) {
                                    altTrans.setTarget(this.trgLoc, trgFragments.get(trgFragments.size() - 1));
                                }
                                altTranslations.add(altTrans);
                                srcSegFrag = null;
                                trgSegFrag = null;
                                altTrans = null;
                                current = inter = new TextFragment();
                            } else if (inter != null && !inter.isEmpty()) {
                                if (this.includeUnsegmentedParts && this.hasText(inter.getCodedText())) {
                                    this.addSegment(inter, srcCont, trgFragments, altTranslations, dfCount, crumbs, movedCodes);
                                } else {
                                    srcCont.append(current);
                                    srcSegFrag = null;
                                    trgSegFrag = null;
                                }
                                current = inter = new TextFragment();
                            }
                            inTU = false;
                        }
                        break;
                    }
                }
            }
            if (inter != null && !inter.isEmpty()) {
                String ctext = inter.getCodedText();
                if (this.includeUnsegmentedParts && this.hasText(ctext)) {
                    int n = TextFragment.indexOfFirstNonWhitespace(ctext, 0, -1, false, false, false, true);
                    if (n > 0) {
                        if (srcCont.isEmpty()) {
                            this.skel.add(ctext.substring(0, n));
                        } else {
                            srcCont.append(new TextPart(ctext.substring(0, n)));
                        }
                        ctext = ctext.substring(n);
                        inter.setCodedText(ctext);
                    }
                    this.addSegment(inter, srcCont, trgFragments, altTranslations, dfCount, crumbs, movedCodes);
                    inter = null;
                } else {
                    srcCont.append(inter);
                }
            }
            boolean bl = changeToSkel = !this.hasText(srcCont);
            if (!hasOriginalSeg && !this.includeUnsegmentedParts) {
                changeToSkel = true;
            }
            if (changeToSkel) {
                if (this.skelWriter == null) {
                    this.skelWriter = new TTXSkeletonWriter();
                }
                this.skelWriter.checkForFilterInternalUse(this.lineBreak);
                if (srcCont.contentIsOneSegment()) {
                    this.skel.append(this.skelWriter.processFragment(srcCont.getFirstContent(), EncoderContext.SKELETON));
                } else {
                    this.skel.append(this.skelWriter.processFragment(srcCont.getUnSegmentedContentCopy(), EncoderContext.SKELETON));
                }
                this.tu = null;
                return false;
            }
            String toMoveAfter = "";
            if (srcCont.hasBeenSegmented()) {
                TextContainer tc = this.tu.getSource();
                List<Range> ranges = tc.getSegments().getRanges();
                tc.joinAll();
                tc.getFirstContent().renumberCodes();
                tc.getSegments().create(ranges, true);
                TextContainer cont = srcCont.clone();
                int i = 0;
                for (Segment seg : cont.getSegments()) {
                    seg.text = trgFragments.get(i);
                    ++i;
                }
                this.tu.setTarget(this.trgLoc, cont);
                tc = this.tu.getTarget(this.trgLoc);
                ranges = tc.getSegments().getRanges();
                tc.joinAll();
                tc.getFirstContent().renumberCodes();
                tc.getSegments().create(ranges, true);
                i = 0;
                for (Segment seg : tc.getSegments()) {
                    AltTranslation altTmp = altTranslations.get(i);
                    if (altTmp != null) {
                        AltTranslationsAnnotation ann = new AltTranslationsAnnotation();
                        ann.add(altTmp);
                        seg.setAnnotation(ann);
                    }
                    ++i;
                }
            } else if (dfCount < 0 || crumbs.startsWith("c")) {
                toMoveAfter = this.moveDFCodesToString(srcCont.getSegments().getLastContent(), dfCount, crumbs);
            }
            this.tu.setId(String.valueOf(++this.tuId));
            this.skel.addContentPlaceholder(this.tu);
            this.tu.setSkeleton(this.skel);
            this.tu.setPreserveWhitespaces(true);
            this.tu.setMimeType("application/x-ttx+xml");
            this.queue.add(new Event(EventType.TEXT_UNIT, this.tu));
            this.skel = new GenericSkeleton();
            if (movedCodes.length() > 0) {
                this.skel.add(movedCodes.toString());
            }
            if (!Util.isEmpty(toMoveAfter)) {
                this.skel.add(toMoveAfter);
            }
            return returnValueAfterTextUnitDone;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Error processing top-level ut element.\n" + e.getMessage(), e);
        }
    }

    private void addSegment(TextFragment frag, TextContainer srcCont, ArrayList<TextFragment> trgSegments, ArrayList<AltTranslation> altTranslations, int dfCount, String crumbs, StringBuilder movedCodes) {
        if (dfCount < 0 || crumbs.startsWith("c")) {
            movedCodes.append(this.moveDFCodesToString(frag, dfCount, crumbs));
        }
        srcCont.append(new Segment(null, frag));
        trgSegments.add(new TextFragment());
        altTranslations.add(null);
    }

    private String moveDFCodesToString(TextFragment tf, int dfCount, String crumbs) {
        Code code;
        int i;
        String tmp = "";
        StringBuilder ctext = new StringBuilder(tf.getCodedText());
        List<Code> codes = tf.getCodes();
        int count = 0;
        for (i = 0; i < crumbs.length() && crumbs.charAt(i) == 'c'; ++i) {
            ++count;
        }
        if (count > 0) {
            for (i = 0; i < ctext.length(); ++i) {
                if (!TextFragment.isMarker(ctext.charAt(i)) || !(code = codes.get(TextFragment.toIndex(ctext.charAt(i + 1)))).getType().equals(DFEND_TYPE)) continue;
                tmp = tmp + code.getOuterData();
                tf.remove(i, i + 2);
                ctext.setLength(0);
                ctext.append(tf.getCodedText());
                ++dfCount;
                if (--count == 0) break;
            }
            tf.renumberCodes();
        }
        if (dfCount >= 0) {
            return tmp;
        }
        for (i = ctext.length() - 1; i >= 0; --i) {
            if (!TextFragment.isMarker(ctext.charAt(i)) || (code = codes.get(TextFragment.toIndex(ctext.charAt(i + 1)))).getType() == null || !code.getType().equals(DFEND_TYPE)) continue;
            tmp = code.getOuterData() + tmp;
            tf.remove(i, i + 2);
            ctext.setLength(0);
            ctext.append(tf.getCodedText());
            if (++dfCount == 0) break;
        }
        return tmp;
    }

    private boolean hasText(TextContainer tc) {
        for (TextPart part : tc) {
            if (!this.hasText(part.getContent().getCodedText())) continue;
            return true;
        }
        return false;
    }

    private boolean hasText(String codedText) {
        for (int i = 0; i < codedText.length(); ++i) {
            if (TextFragment.isMarker(codedText.charAt(i))) {
                ++i;
                continue;
            }
            if (Character.isWhitespace(codedText.charAt(i)) || TTXNOTEXTCHARS.indexOf(codedText.charAt(i)) != -1) continue;
            return true;
        }
        return false;
    }

    private String buildStartElement(boolean store) {
        StringBuilder tmp = new StringBuilder();
        String prefix = this.reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            tmp.append("<" + this.reader.getLocalName());
        } else {
            tmp.append("<" + prefix + ":" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            tmp.append(String.format(" xmlns%s=\"%s\"", prefix != null ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
        }
        count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            prefix = this.reader.getAttributePrefix(i);
            String attrName = String.format("%s%s", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i));
            if (TARGETLANGUAGE_ATTR.equals(attrName)) {
                tmp.append(" TargetLanguage=\"");
                this.skel.append(tmp.toString());
                this.skel.append(this.trgLangCode);
                tmp.setLength(0);
                tmp.append("\"");
                continue;
            }
            tmp.append(String.format(" %s=\"%s\"", attrName, Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, true, null)));
        }
        tmp.append(">");
        if (store) {
            this.skel.append(tmp.toString());
        }
        return tmp.toString();
    }

    private String buildEndElement(boolean store) {
        StringBuilder tmp = new StringBuilder();
        String prefix = this.reader.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            tmp.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
        } else {
            tmp.append("</" + this.reader.getLocalName() + ">");
        }
        if (store) {
            this.skel.append(tmp.toString());
        }
        return tmp.toString();
    }

    private void processUserSettings() {
        String tmp;
        if (this.skelWriter == null) {
            this.skelWriter = new TTXSkeletonWriter();
        }
        if (!Util.isEmpty(tmp = this.reader.getAttributeValue(null, "SourceLanguage")) && !this.srcLoc.equalToString(tmp)) {
            this.logger.warn("Specified source was '{}' but source language in the file is '{}'.\nUsing '{}'.", new Object[]{this.srcLoc.toString(), tmp, tmp});
            this.srcLoc = LocaleId.fromString(tmp);
            this.srcLangCode = tmp;
            this.skelWriter.setSourceLanguageCode(this.srcLangCode);
        }
        if (!Util.isEmpty(tmp = this.reader.getAttributeValue(null, TARGETLANGUAGE_ATTR)) && !this.trgLoc.equalToString(tmp)) {
            this.logger.warn("Specified target was '{}' but target language in the file is '{}'.\nUsing '{}'.", new Object[]{this.trgLoc.toString(), tmp, tmp});
            this.trgLoc = LocaleId.fromString(tmp);
            this.trgLangCode = tmp;
            this.skelWriter.setTargetLanguageCode(this.trgLangCode);
        }
        if (tmp != null) {
            // empty if block
        }
        this.trgDefFont = this.reader.getAttributeValue(null, "TargetDefaultFont");
        if (Util.isEmpty(this.trgDefFont)) {
            this.trgDefFont = "Arial";
        }
        this.buildStartElement(true);
    }

    private void storeUntilEndElement(String name) throws XMLStreamException {
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    this.buildStartElement(true);
                    break;
                }
                case 2: {
                    if (name.equals(this.reader.getLocalName())) {
                        this.buildEndElement(true);
                        this.reader.next();
                        return;
                    }
                    this.buildEndElement(true);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, true, null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                }
            }
        }
    }

    private boolean isInline(String tagName) {
        if (tagName.equals("df")) {
            return true;
        }
        String tmp = this.reader.getAttributeValue(null, "Style");
        if (tmp != null) {
            return !"external".equals(tmp);
        }
        tmp = this.reader.getAttributeValue(null, "Class");
        if (tmp != null) {
            return !"procinstr".equals(tmp);
        }
        return true;
    }

    private boolean isConvertibleToInline() {
        String type = this.reader.getAttributeValue(null, "Type");
        return null == type && 0 < this.numberOfOpenedInternalTags;
    }

    private void createDocumentPartIfNeeded() {
        if (!this.skel.isEmpty(true)) {
            DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            this.skel = new GenericSkeleton();
        }
    }

    private void appendCode(TextFragment.TagType tagType, int id, String tagName, String type, boolean store, TextFragment content) {
        try {
            String prefix;
            int endStack = 1;
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = null;
            outerCode = new StringBuilder();
            outerCode.append("<" + tagName);
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                prefix = this.reader.getAttributePrefix(i);
                outerCode.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i), Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, true, null)));
            }
            outerCode.append(">");
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        int i;
                        if (store) {
                            this.buildStartElement(store);
                        }
                        StringBuilder tmpg = new StringBuilder();
                        if (tagName.equals(this.reader.getLocalName())) {
                            ++endStack;
                        }
                        if ((prefix = this.reader.getPrefix()) == null || prefix.length() == 0) {
                            tmpg.append("<" + this.reader.getLocalName());
                        } else {
                            tmpg.append("<" + prefix + ":" + this.reader.getLocalName());
                        }
                        count = this.reader.getNamespaceCount();
                        for (i = 0; i < count; ++i) {
                            prefix = this.reader.getNamespacePrefix(i);
                            tmpg.append(String.format(" xmlns%s=\"%s\"", prefix != null ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
                        }
                        count = this.reader.getAttributeCount();
                        for (i = 0; i < count; ++i) {
                            if (!this.reader.isAttributeSpecified(i)) continue;
                            prefix = this.reader.getAttributePrefix(i);
                            tmpg.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i), Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, true, null)));
                        }
                        tmpg.append(">");
                        innerCode.append(tmpg.toString());
                        outerCode.append(tmpg.toString());
                        break;
                    }
                    case 2: {
                        if (store) {
                            this.buildEndElement(store);
                        }
                        if (tagName.equals(this.reader.getLocalName()) && --endStack == 0) {
                            Code code = content.append(tagType, type, innerCode.toString(), id);
                            outerCode.append("</" + tagName + ">");
                            code.setOuterData(outerCode.toString());
                            return;
                        }
                        prefix = this.reader.getPrefix();
                        if (prefix == null || prefix.length() == 0) {
                            innerCode.append("</" + this.reader.getLocalName() + ">");
                            outerCode.append("</" + this.reader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        outerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.reader.getText());
                        outerCode.append(Util.escapeToXML(this.reader.getText(), 0, true, null));
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, true, null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesFileContainSegment(URI inputURI, String encoding) throws IOException {
        try (BufferedReader reader = null;){
            int count = 0;
            reader = new BufferedReader(new InputStreamReader(this.input.getStream(), encoding));
            String line = reader.readLine();
            while (line != null) {
                ++count;
                if (line.contains("<Tuv ")) {
                    boolean bl = true;
                    return bl;
                }
                line = reader.readLine();
                if (count <= 5000) continue;
                break;
            }
        }
        return false;
    }
}

