/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tmx;

import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.skeleton.GenericSkeleton;

public class TmxUtils {
    static void copyXMLNSToBuffer(StringBuilder sb, String prefix, String namespaceURI) {
        sb.append(" xmlns");
        if (prefix != null && !"".equals(prefix)) {
            sb.append(":");
            sb.append(prefix);
        }
        sb.append("=\"");
        sb.append(namespaceURI);
        sb.append("\"");
    }

    static void copyXMLNSToSkeleton(GenericSkeleton skel, String prefix, String namespaceURI) {
        StringBuilder sb = new StringBuilder();
        TmxUtils.copyXMLNSToBuffer(sb, prefix, namespaceURI);
        skel.append(sb.toString());
    }

    static void copyAttributeToBuffer(StringBuilder sb, XMLStreamReader reader, int attrIndex, String lineBreak, boolean escapeGT) {
        String prefix = reader.getAttributePrefix(attrIndex);
        sb.append(" ");
        if (prefix != null && !"".equals(prefix)) {
            sb.append(prefix).append(":");
        }
        sb.append(reader.getAttributeLocalName(attrIndex));
        sb.append("=\"");
        sb.append(Util.escapeToXML(reader.getAttributeValue(attrIndex).replace("\n", lineBreak), 3, escapeGT, null));
        sb.append('\"');
    }

    static void copyAttributeToSkeleton(GenericSkeleton skel, XMLStreamReader reader, int attrIndex, String lineBreak, boolean escapeGT) {
        StringBuilder sb = new StringBuilder();
        TmxUtils.copyAttributeToBuffer(sb, reader, attrIndex, lineBreak, escapeGT);
        skel.append(sb.toString());
    }
}

