/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface WorkbookFragments {
    public List<String> worksheetNames();

    public String localisedWorksheetNameFor(String var1);

    public String localisedWorksheetNameFor(int var1);

    public boolean worksheetHiddenFor(String var1);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public static final class Default
    implements WorkbookFragments {
        private static final String EMPTY = "";
        private static final String WORKSHEET_NAME_HAS_NOT_BEEN_FOUND = "The provided worksheet name has not been found: ";
        private static final String WORKBOOK = "workbook";
        private static final String SHEET = "sheet";
        private static final QName SHEET_NAME = new QName("name");
        private static final QName SHEET_STATE = new QName("state");
        private static final String ID = "id";
        private static final String HIDDEN = "hidden";
        private final ConditionalParameters conditionalParameters;
        private final Relationships relationships;
        private final List<String> worksheetNames;
        private final Map<String, String> localisedWorksheetNames;
        private final Set<String> hiddenWorksheets;
        private QName sheet;
        private QName id;

        Default(ConditionalParameters conditionalParameters, Relationships relationships) {
            this(conditionalParameters, relationships, new ArrayList<String>(), new HashMap<String, String>(), new HashSet<String>());
        }

        Default(ConditionalParameters conditionalParameters, Relationships relationships, List<String> worksheetNames, Map<String, String> localisedWorksheetNames, Set<String> hiddenWorksheets) {
            this.conditionalParameters = conditionalParameters;
            this.relationships = relationships;
            this.worksheetNames = worksheetNames;
            this.localisedWorksheetNames = localisedWorksheetNames;
            this.hiddenWorksheets = hiddenWorksheets;
        }

        @Override
        public List<String> worksheetNames() {
            return this.worksheetNames;
        }

        @Override
        public String localisedWorksheetNameFor(String worksheetName) {
            if (!this.localisedWorksheetNames.containsKey(worksheetName)) {
                throw new IllegalStateException(WORKSHEET_NAME_HAS_NOT_BEEN_FOUND.concat(worksheetName));
            }
            return this.localisedWorksheetNames.get(worksheetName);
        }

        @Override
        public String localisedWorksheetNameFor(int worksheetNumber) {
            if (this.worksheetNames.size() < worksheetNumber) {
                return EMPTY;
            }
            String name = this.worksheetNames.get(worksheetNumber - 1);
            return null == name ? EMPTY : this.localisedWorksheetNames.get(name);
        }

        @Override
        public boolean worksheetHiddenFor(String worksheetName) {
            if (!this.worksheetNames.contains(worksheetName)) {
                return false;
            }
            return this.hiddenWorksheets.contains(worksheetName);
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (!e.isStartElement()) continue;
                StartElement el = e.asStartElement();
                if (WORKBOOK.equals(el.getName().getLocalPart())) {
                    this.qualifyNames(el);
                    continue;
                }
                if (!el.getName().equals(this.sheet)) continue;
                if (null == this.id) {
                    this.qualifyIdName(el);
                }
                String worksheetName = this.relationshipTargetFor(el.getAttributeByName(this.id).getValue());
                this.worksheetNames.add(worksheetName);
                this.localisedWorksheetNames.put(worksheetName, el.getAttributeByName(SHEET_NAME).getValue());
                String state = XMLEventHelpers.getAttributeValue(el, SHEET_STATE);
                if (this.conditionalParameters.getTranslateExcelHidden() || !HIDDEN.equals(state)) continue;
                this.hiddenWorksheets.add(worksheetName);
            }
        }

        private void qualifyNames(StartElement startElement) {
            this.sheet = new QName(startElement.getName().getNamespaceURI(), SHEET, startElement.getName().getPrefix());
            this.qualifyIdName(startElement);
        }

        private void qualifyIdName(StartElement startElement) {
            String namespaceUri = startElement.getNamespaceURI("r");
            if (null == namespaceUri) {
                return;
            }
            this.id = new QName(namespaceUri, ID, "r");
        }

        private String relationshipTargetFor(String id) {
            Relationships.Rel rel = this.relationships.getRelById(id);
            if (rel == null) {
                throw new IllegalStateException("A non-existent relationship is requested: " + id);
            }
            return rel.target;
        }
    }
}

