/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.CellReference;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ExcelWorksheetTransUnitProperty;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.Text;
import net.sf.okapi.filters.openxml.TextUnitMapper;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

class StringItemTextUnitMapper
extends TextUnitMapper {
    private StringItem stringItem;
    private String worksheet;
    private CellReference cellReference;

    StringItemTextUnitMapper(IdGenerator idGenerator, XMLEventFactory eventFactory, StringItem stringItem, String worksheet, CellReference cellReference) {
        super(idGenerator, eventFactory);
        this.stringItem = stringItem;
        this.worksheet = worksheet;
        this.cellReference = cellReference;
    }

    @Override
    public List<ITextUnit> map() {
        List<ITextUnit> list;
        if (this.stringItem.isStyled()) {
            this.textUnits = this.mapStyledText();
            list = this.textUnits;
        } else {
            list = this.mapText();
        }
        return list;
    }

    private List<ITextUnit> mapStyledText() {
        if (this.stringItem.getChunks().size() <= 2) {
            for (XMLEvents xMLEvents : this.stringItem.getChunks()) {
                if (!(xMLEvents instanceof Run) && !(xMLEvents instanceof Text)) continue;
                throw new IllegalStateException("Unexpected structure");
            }
            return Collections.emptyList();
        }
        TextUnit textUnit = new TextUnit(this.idGenerator.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment textFragment = new TextFragment();
        textUnit.setSource(new TextContainer(textFragment));
        textUnit.setName(this.worksheet + "!" + this.cellReference);
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.CELL_REFERENCE.getKeyName(), this.cellReference.toString(), true));
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.SHEET_NAME.getKeyName(), this.worksheet, true));
        List<Chunk> chunks = this.stringItem.getChunks().subList(1, this.stringItem.getChunks().size() - 1);
        this.baseRunProperties(chunks, this.stringItem.getRunName());
        boolean runHasText = false;
        for (Chunk chunk : chunks) {
            if (chunk instanceof Run) {
                runHasText |= this.processRun(textUnit, (Run)chunk);
                continue;
            }
            this.addIsolatedCode(textFragment, chunk);
        }
        this.popAllRunCodes(textFragment);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>(this.referentTus.size() + 1);
        if (runHasText || !this.referentTus.isEmpty()) {
            BlockSkeleton skel = new BlockSkeleton(this.stringItem.getBlock(), this.baseRunProperties, this.hiddenCodes, this.visibleCodes);
            skel.setParent(textUnit);
            textUnit.setSkeleton(skel);
            tus.add(textUnit);
        }
        tus.addAll(this.referentTus);
        return tus;
    }

    private List<ITextUnit> mapText() {
        TextUnit textUnit = new TextUnit(this.idGenerator.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment tf = new TextFragment();
        textUnit.setSource(new TextContainer(tf));
        textUnit.setMimeType("text/xml");
        textUnit.setName(this.worksheet + "!" + this.cellReference);
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.CELL_REFERENCE.getKeyName(), this.cellReference.toString(), true));
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.SHEET_NAME.getKeyName(), this.worksheet, true));
        Text text = (Text)this.stringItem.getChunks().get(1);
        this.addText(tf, text.characters().getData());
        GenericSkeleton skel = new GenericSkeleton();
        skel.add(XMLEventSerializer.serialize(this.stringItem.getChunks().get(0)));
        skel.add(XMLEventSerializer.serialize(text.startElement()));
        skel.addContentPlaceholder(textUnit);
        skel.add(XMLEventSerializer.serialize(text.endElement()));
        skel.add(XMLEventSerializer.serialize(this.stringItem.getChunks().get(2)));
        skel.setParent(textUnit);
        textUnit.setSkeleton(skel);
        return Collections.singletonList(textUnit);
    }
}

