/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.SharedStrings;

class SharedStringsDenormalizer {
    private static final String TABLE = "sst";
    private static final String ENTRY = "si";
    private static final QName COUNT_ATTR = new QName("count");
    private static final QName UNIQUE_ATTR = new QName("uniqueCount");
    private final XMLEventFactory factory;
    private final SharedStrings sharedStrings;
    private final List<SharedString> stringData;
    private QName table;
    private QName entry;

    SharedStringsDenormalizer(XMLEventFactory factory, SharedStrings sharedStrings) {
        this.factory = factory;
        this.sharedStrings = sharedStrings;
        this.stringData = new ArrayList<SharedString>();
    }

    void process(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        this.readTable(reader);
        this.writeTable(writer);
        writer.close();
    }

    private void readTable(XMLEventReader reader) throws XMLStreamException {
        SharedString currentSSI = null;
        int currentIndex = 0;
        while (reader.hasNext()) {
            XMLEvent el;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                el = event.asStartElement();
                if (el.getName().getLocalPart().equals(TABLE)) {
                    this.qualifyNames((StartElement)el);
                }
                if (this.entry.equals(el.getName())) {
                    currentSSI = new SharedString(currentIndex++);
                }
                if (currentSSI == null) continue;
                currentSSI.addEvent(event);
                continue;
            }
            if (event.isEndElement()) {
                el = event.asEndElement();
                if (currentSSI != null) {
                    currentSSI.addEvent(event);
                }
                if (!this.entry.equals(el.getName())) continue;
                this.stringData.add(currentSSI);
                currentSSI = null;
                continue;
            }
            if (!event.isCharacters() || currentSSI == null) continue;
            currentSSI.addEvent(event);
        }
    }

    private void qualifyNames(StartElement startElement) {
        this.table = startElement.getName();
        this.entry = new QName(startElement.getName().getNamespaceURI(), ENTRY, startElement.getName().getPrefix());
    }

    private void writeTable(XMLEventWriter writer) throws XMLStreamException {
        writer.add(this.factory.createStartDocument(StandardCharsets.UTF_8.name(), "1.0", true));
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        List<SharedStrings.Item> items = this.sharedStrings.items();
        String count = String.valueOf(items.size());
        attrs.add(this.factory.createAttribute(COUNT_ATTR, count));
        attrs.add(this.factory.createAttribute(UNIQUE_ATTR, count));
        StartElement sstStart = this.factory.createStartElement(this.table, attrs.iterator(), Collections.singleton(this.factory.createNamespace(this.table.getNamespaceURI())).iterator());
        writer.add(sstStart);
        int newIndex = 0;
        for (SharedStrings.Item item : items) {
            if (newIndex++ != item.newIndex()) {
                throw new IllegalStateException("Index mismatch: expected " + item.newIndex() + " found " + newIndex);
            }
            if (item.events().isEmpty()) {
                this.stringData.get(item.originalIndex()).writeEvents(writer);
                continue;
            }
            writer.add(this.factory.createStartElement(this.entry, null, null));
            for (XMLEvent event : item.events()) {
                writer.add(event);
            }
            writer.add(this.factory.createEndElement(this.entry, null));
        }
        writer.add(this.factory.createEndElement(this.table, null));
        writer.add(this.factory.createEndDocument());
    }

    static class SharedString {
        private List<XMLEvent> events = new ArrayList<XMLEvent>();
        private int originalIndex;

        SharedString(int originalIndex) {
            this.originalIndex = originalIndex;
        }

        void addEvent(XMLEvent e) {
            this.events.add(e);
        }

        void writeEvents(XMLEventWriter writer) throws XMLStreamException {
            for (XMLEvent e : this.events) {
                writer.add(e);
            }
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }
    }
}

