/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Relationships {
    private static final Logger LOGGER = LoggerFactory.getLogger(Relationships.class);
    static final String UNEXPECTED_NUMBER_OF_RELATIONSHIPS = "Unexpected number of relationships";
    static final String ROOT_RELS_PART_NAME = "_rels/.rels";
    private static final String RELATIONSHIPS = "Relationships";
    private static final String RELATIONSHIP = "Relationship";
    private static final QName ID_ATTR = new QName("Id");
    private static final QName TARGET_ATTR = new QName("Target");
    private static final QName TYPE_ATTR = new QName("Type");
    private static final QName TARGET_MODE = new QName("TargetMode");
    private final XMLInputFactory factory;
    private Map<String, Rel> relsById = new HashMap<String, Rel>();
    private Map<String, List<Rel>> relsByType = new HashMap<String, List<Rel>>();
    private String targetBase;
    private QName relationshipTagName;

    public Relationships(XMLInputFactory factory) {
        this.factory = factory;
    }

    static List<String> mapRelsToTargets(List<Rel> rels) {
        if (rels == null || rels.isEmpty()) {
            throw new OkapiBadFilterInputException(UNEXPECTED_NUMBER_OF_RELATIONSHIPS);
        }
        ArrayList<String> targets = new ArrayList<String>(rels.size());
        for (Rel rel : rels) {
            targets.add(rel.target);
        }
        return targets;
    }

    private void addRelationship(String id, String type, String target, String targetMode) {
        String normalizedTarget = target;
        if (!"External".equals(targetMode) && (normalizedTarget = this.normalizeTarget(target)) == null) {
            return;
        }
        Rel rel = new Rel(normalizedTarget, targetMode, type, id);
        List<Rel> rels = this.relsByType.get(type);
        if (rels == null) {
            rels = new ArrayList<Rel>();
            this.relsByType.put(type, rels);
        }
        rels.add(rel);
        this.relsById.put(id, rel);
    }

    Rel getRelById(String id) {
        return this.relsById.get(id);
    }

    List<Rel> getRelByType(String typeURI) {
        return this.relsByType.get(typeURI);
    }

    boolean hasRelType(String typeUri) {
        return this.relsByType.containsKey(typeUri);
    }

    void parseFromXML(String relsPartName, Reader reader) throws XMLStreamException {
        this.targetBase = this.findTargetBase(relsPartName);
        XMLEventReader eventReader = this.factory.createXMLEventReader(reader);
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (!e.isStartElement()) continue;
            StartElement el = e.asStartElement();
            if (el.getName().getLocalPart().equals(RELATIONSHIPS)) {
                this.qualifyNames(el);
                continue;
            }
            if (!el.getName().equals(this.relationshipTagName)) continue;
            Attribute target = el.getAttributeByName(TARGET_ATTR);
            Attribute targetMode = el.getAttributeByName(TARGET_MODE);
            Attribute id = el.getAttributeByName(ID_ATTR);
            Attribute type = el.getAttributeByName(TYPE_ATTR);
            if (target == null || id == null || type == null) continue;
            this.addRelationship(id.getValue(), type.getValue(), target.getValue(), targetMode != null ? targetMode.getValue() : null);
        }
    }

    private void qualifyNames(StartElement startElement) {
        this.relationshipTagName = new QName(startElement.getName().getNamespaceURI(), RELATIONSHIP, startElement.getName().getPrefix());
    }

    private String findTargetBase(String relsPartName) {
        if (relsPartName.equals(ROOT_RELS_PART_NAME)) {
            return "";
        }
        int i = relsPartName.lastIndexOf("/_rels/");
        if (i == -1) {
            throw new IllegalStateException("Unexpected relationships part path: " + relsPartName);
        }
        return relsPartName.substring(0, i);
    }

    private String normalizeTarget(String target) {
        if (target.startsWith("/")) {
            return target.substring(1);
        }
        String base = this.targetBase;
        while (target.startsWith("../")) {
            int i = base.lastIndexOf("/");
            if (i == -1) {
                if (base.isEmpty()) {
                    LOGGER.warn("Unable to resolve '{}' against path '{}'.", (Object)target, (Object)this.targetBase);
                    return null;
                }
                base = "";
            } else {
                base = base.substring(0, i);
            }
            target = target.substring(3);
        }
        return base + (base.isEmpty() ? "" : "/") + target;
    }

    static class Rel {
        String target;
        String targetMode;
        String id;
        String type;

        Rel(String target, String targetMode, String type, String id) {
            this.target = target;
            this.targetMode = targetMode;
            this.id = id;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rel)) {
                return false;
            }
            Rel r = (Rel)o;
            return Objects.equals(this.target, r.target) && Objects.equals(this.targetMode, r.targetMode) && Objects.equals(this.id, r.id) && Objects.equals(this.type, r.type);
        }

        public int hashCode() {
            return Objects.hash(this.target, this.targetMode, this.id, this.type);
        }
    }
}

