/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.DefaultLocalePair;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.Referent;
import net.sf.okapi.common.skeleton.StorageList;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.AttributesClarification;
import net.sf.okapi.filters.openxml.BlockPropertiesClarification;
import net.sf.okapi.filters.openxml.ClarifiableAttribute;
import net.sf.okapi.filters.openxml.ClarificationContext;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ElementsClarification;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupClarification;
import net.sf.okapi.filters.openxml.MarkupComponentClarification;
import net.sf.okapi.filters.openxml.MarkupZipSkeleton;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.openxml.RunPropertiesClarification;
import net.sf.okapi.filters.openxml.StyledTextSkeletonWriter;
import net.sf.okapi.filters.openxml.StylesClarification;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenXMLFilterWriter
implements IFilterWriter {
    private static final String TRUE_VALUES_ARE_EMPTY = "True values are empty";
    private static final String FALSE_VALUES_ARE_EMPTY = "False values are empty";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ConditionalParameters cparams;
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private String outputPath;
    private Document.General document;
    private ZipOutputStream zipOut;
    private byte[] buffer;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private FontMappings fontMappings;
    private File tempFile;
    private File tempZip;
    private EncoderManager encoderManager;
    private ZipEntry subDocEntry;
    private IFilterWriter subDocWriter;
    private ISkeletonWriter subSkelWriter;
    private TreeMap<Integer, SubDocumentValues> tmSubDoc = new TreeMap();
    private int ndxSubDoc = 0;
    private OutputStream outputStream;

    public OpenXMLFilterWriter() {
        this.inputFactory = XMLInputFactory.newInstance();
        this.outputFactory = XMLOutputFactory.newInstance();
        this.eventFactory = XMLEventFactory.newInstance();
        OpenXMLFilter.configureInputFactory(this.inputFactory);
    }

    OpenXMLFilterWriter(ConditionalParameters cparams, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory) {
        this.cparams = cparams;
        this.inputFactory = inputFactory;
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
    }

    @Override
    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.zipOut == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            if (this.document != null) {
                this.document.close();
                this.document = null;
            }
            this.zipOut.close();
            this.zipOut = null;
            if (this.tempZip != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempZip);
                while ((len = orig.read(this.buffer)) > 0) {
                    dest.write(this.buffer, 0, len);
                }
            }
            this.buffer = null;
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new OkapiIOException("Error closing MS Office 2007 file.");
                }
                if (this.tempZip != null) {
                    this.tempZip.delete();
                    this.tempZip = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "OpenXMLZipFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
            this.encoderManager.setDefaultOptions(null, OpenXMLFilter.ENCODING.name(), "\n");
        }
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return this.subSkelWriter;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                try {
                    this.subDocWriter.handleEvent(event);
                    break;
                }
                catch (Throwable e) {
                    String mess = e.getMessage();
                    throw new OkapiNotImplementedException(mess, e);
                }
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.targetLocale = language;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    private void processStartDocument(StartDocument res) {
        try {
            OutputStream os;
            this.buffer = new byte[2048];
            this.sourceLocale = res.getLocale();
            this.fontMappings = this.cparams.fontMappings().applicableTo(new DefaultLocalePair(this.sourceLocale, this.targetLocale));
            ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
            ZipFile zipTemp = skel.getOriginal();
            File fZip = new File(zipTemp.getName());
            this.document = new Document.General(this.cparams, this.inputFactory, this.outputFactory, this.eventFactory, res.getFilterId(), fZip.toURI(), this.sourceLocale, res.getEncoding(), null, null, null);
            this.document.open();
            this.tempZip = null;
            boolean useTemp = false;
            if (this.outputStream == null) {
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempZip = File.createTempFile("~okapi-24_zfwTmpZip_", null);
                    os = new FileOutputStream(this.tempZip.getAbsolutePath());
                } else {
                    Util.createDirectories(this.outputPath);
                    os = new FileOutputStream(this.outputPath);
                }
            } else {
                os = this.outputStream;
            }
            this.zipOut = new ZipOutputStream(os);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException("Existing file could not be overwritten.", e);
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiIOException("File could not be written.", e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processDocumentPart(Event event) {
        DocumentPart documentPart = (DocumentPart)event.getResource();
        if (documentPart.getSkeleton() instanceof ZipSkeleton) {
            ZipSkeleton skeleton = (ZipSkeleton)documentPart.getSkeleton();
            if (skeleton instanceof MarkupZipSkeleton) {
                this.clarifyMarkup(((MarkupZipSkeleton)skeleton).getMarkup());
            }
            try {
                this.zipOut.putNextEntry(new ZipEntry(skeleton.getEntry().getName()));
                String modifiedContents = skeleton.getModifiedContents();
                if (modifiedContents != null) {
                    this.zipOut.write(modifiedContents.getBytes(StandardCharsets.UTF_8));
                } else {
                    int len;
                    InputStream input = this.document.inputStreamFor(skeleton.getEntry());
                    while ((len = input.read(this.buffer)) > 0) {
                        this.zipOut.write(this.buffer, 0, len);
                    }
                    input.close();
                }
                this.zipOut.closeEntry();
            }
            catch (IOException e) {
                throw new OkapiIOException("Error writing zip file entry.");
            }
        } else {
            this.subDocWriter.handleEvent(event);
        }
    }

    private void clarifyMarkup(Markup markup) {
        markup.apply(this.fontMappings);
        Nameable nameableMarkupComponent = markup.nameableComponent();
        if (null != nameableMarkupComponent) {
            ElementsClarification paragraphPropertiesElementsClarification;
            AttributesClarification paragraphPropertiesAttributesClarification;
            AttributesClarification.Default textBodyPropertiesAttributesClarification;
            ElementsClarification tablePropertiesElementsClarification;
            AttributesClarification tablePropertiesAttributesClarification;
            ClarificationContext clarificationContext = new ClarificationContext(this.cparams, new CreationalParameters(this.eventFactory, nameableMarkupComponent.getName().getPrefix(), nameableMarkupComponent.getName().getNamespaceURI()), this.sourceLocale, this.targetLocale);
            String propertyDefaultValue = (String)XMLEventHelpers.booleanAttributeTrueValues().stream().findFirst().orElseThrow(() -> new IllegalStateException(TRUE_VALUES_ARE_EMPTY));
            String propertyDefaultValueWhenAbsent = (String)XMLEventHelpers.booleanAttributeFalseValues().stream().findFirst().orElseThrow(() -> new IllegalStateException(FALSE_VALUES_ARE_EMPTY));
            ClarifiableAttribute rtlColClarifiableAttribute = new ClarifiableAttribute("", "rtlCol", XMLEventHelpers.booleanAttributeTrueValues());
            AttributesClarification.Bypass bypassAttributesClarification = new AttributesClarification.Bypass();
            ElementsClarification.Bypass bypassElementsClarification = new ElementsClarification.Bypass();
            AttributesClarification.Default rtlAttributesClarification = new AttributesClarification.Default(clarificationContext, new ClarifiableAttribute("", "rtl", XMLEventHelpers.booleanAttributeTrueValues()));
            if ("a".equals(clarificationContext.creationalParameters().getPrefix())) {
                tablePropertiesAttributesClarification = rtlAttributesClarification;
                tablePropertiesElementsClarification = bypassElementsClarification;
                textBodyPropertiesAttributesClarification = new AttributesClarification.Default(clarificationContext, rtlColClarifiableAttribute);
                paragraphPropertiesAttributesClarification = new AttributesClarification.AlignmentAndRtl(clarificationContext, "", "algn", "l", "r", "rtl", XMLEventHelpers.booleanAttributeFalseValues(), XMLEventHelpers.booleanAttributeTrueValues());
                paragraphPropertiesElementsClarification = bypassElementsClarification;
            } else {
                tablePropertiesAttributesClarification = bypassAttributesClarification;
                tablePropertiesElementsClarification = new ElementsClarification.TableBlockPropertyDefault(clarificationContext, "bidiVisual");
                textBodyPropertiesAttributesClarification = new AttributesClarification.Default(new ClarificationContext(this.cparams, new CreationalParameters(this.eventFactory, "a", Namespaces.DrawingML.getURI()), this.sourceLocale, this.targetLocale), rtlColClarifiableAttribute);
                paragraphPropertiesAttributesClarification = bypassAttributesClarification;
                paragraphPropertiesElementsClarification = new ElementsClarification.ParagraphBlockPropertyDefault(clarificationContext, "bidi", propertyDefaultValue, propertyDefaultValueWhenAbsent, XMLEventHelpers.booleanAttributeFalseValues(), XMLEventHelpers.booleanAttributeTrueValues());
            }
            BlockPropertiesClarification.Default tablePropertiesClarification = new BlockPropertiesClarification.Default(clarificationContext, "tblPr", new MarkupComponentClarification.Default(tablePropertiesAttributesClarification, tablePropertiesElementsClarification));
            BlockPropertiesClarification.Default textBodyPropertiesClarification = new BlockPropertiesClarification.Default(clarificationContext, "bodyPr", new MarkupComponentClarification.Default(textBodyPropertiesAttributesClarification, bypassElementsClarification));
            BlockPropertiesClarification.Paragraph paragraphPropertiesClarification = new BlockPropertiesClarification.Paragraph(new BlockPropertiesClarification.Default(clarificationContext, "pPr", new MarkupComponentClarification.Default(paragraphPropertiesAttributesClarification, paragraphPropertiesElementsClarification)));
            MarkupClarification markupClarification = new MarkupClarification(new MarkupComponentClarification.Default(new AttributesClarification.Default(clarificationContext, new ClarifiableAttribute("", "rightToLeft", XMLEventHelpers.booleanAttributeTrueValues())), bypassElementsClarification), new MarkupComponentClarification.Default(new AttributesClarification.Default(clarificationContext, new ClarifiableAttribute("", "readingOrder", Collections.singleton("2"))), bypassElementsClarification), new MarkupComponentClarification.Default(rtlAttributesClarification, bypassElementsClarification), tablePropertiesClarification, textBodyPropertiesClarification, paragraphPropertiesClarification, new StylesClarification.Word(tablePropertiesClarification, paragraphPropertiesClarification, new RunPropertiesClarification.Default(clarificationContext, new MarkupComponentClarification.Default(bypassAttributesClarification, new ElementsClarification.RunPropertyLang(new ElementsClarification.RunPropertyDefault(clarificationContext, "rtl", propertyDefaultValue, propertyDefaultValueWhenAbsent, XMLEventHelpers.booleanAttributeFalseValues(), XMLEventHelpers.booleanAttributeTrueValues()), "lang", "bidi")))));
            markupClarification.performFor(markup);
        }
    }

    private void processStartSubDocument(StartSubDocument res) {
        ++this.ndxSubDoc;
        try {
            this.tempFile = File.createTempFile("~okapi-25_zfwTmp" + this.ndxSubDoc + "_", null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error opening temporary zip output file.");
        }
        ISkeleton skel = res.getSkeleton();
        ConditionalParameters conditionalParameters = (ConditionalParameters)res.getFilterParameters();
        if (skel instanceof ZipSkeleton) {
            this.subDocEntry = ((ZipSkeleton)res.getSkeleton()).getEntry();
            this.subSkelWriter = this.document.isStyledTextPart(this.subDocEntry) ? new StyledTextSkeletonWriter(this.subDocEntry.getName(), this.sourceLocale, this.targetLocale, conditionalParameters, this.eventFactory, this.fontMappings, this.innerGenericSkeletonWriter()) : new GenericSkeletonWriter();
        } else {
            this.subDocEntry = new ZipEntry(res.getName());
            this.subSkelWriter = new GenericSkeletonWriter();
        }
        this.subDocWriter = new GenericFilterWriter(this.subSkelWriter, this.getEncoderManager());
        this.subDocWriter.setOptions(this.targetLocale, OpenXMLFilter.ENCODING.name());
        this.subDocWriter.setOutput(this.tempFile.getAbsolutePath());
        StartDocument sd = new StartDocument("sd");
        sd.setLineBreak("\n");
        sd.setSkeleton(res.getSkeleton());
        sd.setLocale(this.sourceLocale);
        this.subDocWriter.handleEvent(new Event(EventType.START_DOCUMENT, sd));
        SubDocumentValues subDocumentValues = new SubDocumentValues(this.subDocEntry, this.subDocWriter, this.subSkelWriter, this.tempFile);
        this.tmSubDoc.put(this.ndxSubDoc, subDocumentValues);
    }

    private GenericSkeletonWriter innerGenericSkeletonWriter() {
        return new GenericSkeletonWriter(this.sourceLocale, this.targetLocale, null, this.getEncoderManager(), false, false, new LinkedHashMap<String, Referent>(), new Stack<StorageList>(), OpenXMLFilter.ENCODING.name(), 0, null);
    }

    private void processEndSubDocument(Ending res) {
        try {
            int len;
            SubDocumentValues subDocumentValues = this.tmSubDoc.get(this.ndxSubDoc--);
            this.subDocEntry = subDocumentValues.zipEntry;
            this.subDocWriter = subDocumentValues.filterWriter;
            this.subSkelWriter = subDocumentValues.skeletonWriter;
            this.tempFile = subDocumentValues.tempFile;
            this.subDocWriter.handleEvent(new Event(EventType.END_DOCUMENT, res));
            this.subDocWriter.close();
            this.zipOut.putNextEntry(new ZipEntry(this.subDocEntry.getName()));
            FileInputStream input = new FileInputStream(this.tempFile);
            while ((len = ((InputStream)input).read(this.buffer)) > 0) {
                this.zipOut.write(this.buffer, 0, len);
            }
            ((InputStream)input).close();
            this.zipOut.closeEntry();
            this.tempFile.delete();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zip output file.");
        }
    }

    @Override
    public void setParameters(IParameters params) {
        this.cparams = (ConditionalParameters)params;
    }

    @Override
    public ConditionalParameters getParameters() {
        return this.cparams;
    }

    private static class SubDocumentValues {
        private final ZipEntry zipEntry;
        private final IFilterWriter filterWriter;
        private final ISkeletonWriter skeletonWriter;
        private final File tempFile;

        SubDocumentValues(ZipEntry zipEntry, IFilterWriter filterWriter, ISkeletonWriter skeletonWriter, File tempFile) {
            this.zipEntry = zipEntry;
            this.filterWriter = filterWriter;
            this.skeletonWriter = skeletonWriter;
            this.tempFile = tempFile;
        }
    }
}

