/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.okapi.filters.mif.Token;

interface Statement
extends Token,
Iterable<Token> {
    public Token firstTokenOf(Token.Type var1);

    public Statement firstStatementWith(String var1);

    public List<Statement> statementsWith(String var1);

    public Type statementType();

    public static enum Type {
        EMPTY,
        COMMENT,
        MACRO,
        MARKUP;

    }

    public static class Default
    implements Statement {
        private final List<Token> tokens;
        private final Type type;

        Default(List<Token> tokens, Type type) {
            this.tokens = tokens;
            this.type = type;
        }

        Default(Token token, Type type) {
            this(Collections.singletonList(token), type);
        }

        @Override
        public Iterator<Token> iterator() {
            return this.tokens.iterator();
        }

        @Override
        public Token firstTokenOf(Token.Type type) {
            return this.tokens.stream().filter(t -> t.type() == type).findFirst().orElse(new Token.Default("", type));
        }

        @Override
        public Statement firstStatementWith(String identity) {
            return this.statementsWith(identity).stream().findFirst().orElse(new Default(Collections.emptyList(), Type.EMPTY));
        }

        @Override
        public List<Statement> statementsWith(String identity) {
            return this.tokens.stream().filter(t -> t.type() == Token.Type.STATEMENT).map(t -> (Statement)t).filter(s -> s.firstTokenOf(Token.Type.IDENTITY).toString().equals(identity)).collect(Collectors.toList());
        }

        @Override
        public Type statementType() {
            return this.type;
        }

        @Override
        public Token.Type type() {
            return Token.Type.STATEMENT;
        }

        @Override
        public String toString() {
            return this.tokens.stream().map(t -> t.toString()).collect(Collectors.joining());
        }
    }
}

