/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.Story;
import net.sf.okapi.filters.idml.StoryEventsAccumulator;
import net.sf.okapi.filters.idml.StoryParser;
import net.sf.okapi.filters.idml.SubDocument;
import net.sf.okapi.filters.idml.ZipInput;

class StorySubDocument
implements SubDocument {
    private static final String MIME_TYPE = "text/xml";
    private final Parameters parameters;
    private final ZipInput<XMLEventReader> zipInputReader;
    private final XMLEventFactory eventFactory;
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;
    private final String parentId;
    private final String id;
    private Iterator<Event> eventsIterator;

    StorySubDocument(Parameters parameters, ZipInput<XMLEventReader> zipInputReader, XMLEventFactory eventFactory, ZipFile zipFile, ZipEntry zipEntry, String parentId, String id) {
        this.parameters = parameters;
        this.zipInputReader = zipInputReader;
        this.eventFactory = eventFactory;
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.parentId = parentId;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event open() throws IOException, XMLStreamException {
        try (XMLEventReader eventReader = null;){
            eventReader = this.zipInputReader.of(this.zipEntry);
            Story story = new StoryParser(this.parameters, this.eventFactory, eventReader).parse();
            IdGenerator documentPartIdGenerator = new IdGenerator(this.zipEntry.getName(), "dp");
            IdGenerator textUnitIdGenerator = new IdGenerator(this.zipEntry.getName(), "tu");
            List<Event> events = new StoryEventsAccumulator(story, this.parameters, this.eventFactory, documentPartIdGenerator, textUnitIdGenerator).accumulate();
            events.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.id), new ZipSkeleton(this.zipFile, this.zipEntry)));
            this.eventsIterator = events.iterator();
        }
        return this.createStartSubDocumentEvent();
    }

    protected Event createStartSubDocumentEvent() {
        StartSubDocument sd = new StartSubDocument(this.parentId, this.id);
        sd.setName(this.zipEntry.getName());
        sd.setMimeType(MIME_TYPE);
        ZipSkeleton zs = new ZipSkeleton(this.zipFile, this.zipEntry);
        sd.setSkeleton(zs);
        sd.setFilterId("okf_idml");
        sd.setFilterParameters(this.parameters);
        return new Event(EventType.START_SUBDOCUMENT, sd);
    }

    @Override
    public boolean hasNextEvent() {
        return this.eventsIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.eventsIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

