/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.OrderingIdioms;
import net.sf.okapi.filters.idml.SpreadItem;
import net.sf.okapi.filters.idml.SpreadItemHolder;

class Spread {
    private final String id;
    private final String activeLayerId;
    private final String transformation;
    private final List<SpreadItem> spreadItems;

    Spread(String id, String activeLayerId, String transformation, List<SpreadItem> spreadItems) {
        this.id = id;
        this.activeLayerId = activeLayerId;
        this.transformation = transformation;
        this.spreadItems = spreadItems;
    }

    String getId() {
        return this.id;
    }

    String getActiveLayerId() {
        return this.activeLayerId;
    }

    String getTransformation() {
        return this.transformation;
    }

    List<SpreadItem> getSpreadItems() {
        return this.spreadItems;
    }

    static class SpreadComparator
    implements Comparator<Spread> {
        SpreadComparator() {
        }

        @Override
        public int compare(Spread spread, Spread anotherSpread) {
            OrderingIdioms.TransformationMatrix spreadTransformationMatrix = OrderingIdioms.TransformationMatrix.fromString(spread.getTransformation());
            OrderingIdioms.TransformationMatrix anotherSpreadTransformationMatrix = OrderingIdioms.TransformationMatrix.fromString(anotherSpread.getTransformation());
            return Double.compare(spreadTransformationMatrix.getTy(), anotherSpreadTransformationMatrix.getTy());
        }
    }

    static class SpreadBuilder
    implements Builder<Spread>,
    SpreadItemHolder {
        private String id;
        private String activeLayerId;
        private String transformation;
        private List<SpreadItem> spreadItems = new ArrayList<SpreadItem>();

        SpreadBuilder() {
        }

        SpreadBuilder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public String getActiveLayerId() {
            return this.activeLayerId;
        }

        SpreadBuilder setActiveLayerId(String activeLayerId) {
            this.activeLayerId = activeLayerId;
            return this;
        }

        SpreadBuilder setTransformation(String transformation) {
            this.transformation = transformation;
            return this;
        }

        @Override
        public SpreadBuilder addSpreadItem(SpreadItem spreadItem) {
            this.spreadItems.add(spreadItem);
            return this;
        }

        @Override
        public Spread build() {
            return new Spread(this.id, this.activeLayerId, this.transformation, this.spreadItems);
        }
    }
}

