/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import net.sf.okapi.filters.doxygen.DoxygenCommand;
import net.sf.okapi.filters.doxygen.DoxygenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Parameters
extends BaseParameters
implements ISimplifierRulesParameters {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String DOXYGEN_PARAMETERS = "doxygenConfiguration.yml";
    private Yaml yaml = new Yaml();
    private Map<String, Object> config;
    private Map<String, Object> doxygenCommands;
    private Map<String, Object> htmlCommands;
    private IdentityHashMap<Pattern, Object> customCommands;
    private boolean preserveWhitespace = false;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.config = (Map)this.yaml.load(DoxygenFilter.class.getResourceAsStream(DOXYGEN_PARAMETERS));
        this.initialize();
        this.setSimplifierRules(null);
    }

    private void initialize() {
        Object whitespace;
        this.doxygenCommands = new HashMap<String, Object>();
        Object doxygen = this.config.get("doxygen_commands");
        if (doxygen != null) {
            this.doxygenCommands = (Map)doxygen;
        }
        this.htmlCommands = new HashMap<String, Object>();
        Object html = this.config.get("html_commands");
        if (html != null) {
            this.htmlCommands = (Map)html;
        }
        if ((whitespace = this.config.get("preserve_whitespace")) != null) {
            this.preserveWhitespace = (Boolean)whitespace;
        }
        this.customCommands = new IdentityHashMap();
        Object custom = this.config.get("custom_commands");
        if (custom != null) {
            for (HashMap c : (ArrayList)custom) {
                try {
                    String regex = (String)c.get("pattern");
                    this.customCommands.put(Pattern.compile(regex), c);
                }
                catch (PatternSyntaxException ex) {
                    this.LOGGER.warn("Regex pattern was invalid: {}", (Object)ex.getPattern());
                }
                catch (NullPointerException ex) {
                    this.LOGGER.warn("User-supplied custom regex for the Doxygen filter was null. Make sure to enclose it in double-quotes in the config file.");
                }
            }
        }
    }

    public boolean isDoxygenCommand(String cmd) {
        if (cmd.equals("@{") || cmd.equals("@}")) {
            return true;
        }
        if (!(cmd.startsWith("\\") || cmd.startsWith("@") || cmd.startsWith("<"))) {
            return false;
        }
        if (cmd.startsWith("<")) {
            return this.htmlCommands.containsKey(this.clean(cmd));
        }
        return this.doxygenCommands.containsKey(this.clean(cmd));
    }

    private String clean(String cmd) {
        if (cmd.equals("@{") || cmd.equals("@}")) {
            return cmd;
        }
        return cmd.replaceAll("[\\\\@<>/]|[\\[\\(\\{].*|\\s.*", "");
    }

    @Override
    public String toString() {
        return this.yaml.dump(this.config);
    }

    @Override
    public void fromString(String data) {
        this.config = (Map)this.yaml.load(data);
        this.initialize();
    }

    public DoxygenCommand commandInfo(String rawCommand, Pattern pattern) {
        if (this.customCommands.containsKey(pattern)) {
            Map data = null;
            data = (Map)this.customCommands.get(pattern);
            return new DoxygenCommand(data, rawCommand, rawCommand, this);
        }
        if (!this.isDoxygenCommand(rawCommand)) {
            return null;
        }
        String cmdName = this.clean(rawCommand);
        Map data = null;
        data = rawCommand.startsWith("<") ? (Map)this.htmlCommands.get(cmdName) : (Map)this.doxygenCommands.get(cmdName);
        return new DoxygenCommand(data, cmdName, rawCommand, this);
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public IdentityHashMap<Pattern, Object> getCustomCommandPatterns() {
        return this.customCommands;
    }

    @Override
    public boolean getBoolean(String name) {
        return false;
    }

    @Override
    public void setBoolean(String name, boolean value) {
    }

    @Override
    public String getString(String name) {
        return null;
    }

    @Override
    public void setString(String name, String value) {
    }

    @Override
    public int getInteger(String name) {
        return 0;
    }

    @Override
    public void setInteger(String name, int value) {
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

