/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String AZUREKEY = "azureKey";
    private static final String CATEGORY = "category";
    private static final String BASE_URL = "baseURL";
    static final String DEFAULT_CATEGORY = "general";
    private static final String DEFAULT_BASE_URL = "https://api.cognitive.microsofttranslator.com";

    public String getAzureKey() {
        return this.getString(AZUREKEY);
    }

    public void setAzureKey(String azureKey) {
        this.setString(AZUREKEY, azureKey);
    }

    public String getCategory() {
        return this.getString(CATEGORY);
    }

    public void setCategory(String category) {
        this.setString(CATEGORY, category == null ? DEFAULT_CATEGORY : category);
    }

    public String getBaseURL() {
        return this.getString(BASE_URL);
    }

    public void setBaseURL(String baseURL) {
        this.setString(BASE_URL, baseURL);
    }

    @Override
    public void reset() {
        super.reset();
        this.setAzureKey("");
        this.setCategory(DEFAULT_CATEGORY);
        this.setBaseURL(DEFAULT_BASE_URL);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(AZUREKEY, "Azure Key (See docs.microsoft.com/en-us/azure/cognitive-services/cognitive-services-apis-create-account)", "Microsoft Azure subscription key");
        desc.add(CATEGORY, "Category (See https://docs.microsoft.com/en-us/azure/cognitive-services/translator/reference/v3-0-translate?tabs=curl#request-parameters)", "A name to use a customized system.");
        desc.add(BASE_URL, "Base URL of the translate service, before /translate", "This is the part before /translate. See https://docs.microsoft.com/en-us/azure/cognitive-services/translator/reference/v3-0-reference#base-urls");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft MT Connector Settings", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(AZUREKEY));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        desc.addTextInputPart(paramsDesc.get(BASE_URL));
        return desc;
    }
}

