/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.okapi.common.resource.Property;

public interface IWithProperties {
    public static void copy(IWithProperties from, IWithProperties to) {
        if (from == null || to == null) {
            return;
        }
        for (String propName : from.getPropertyNames()) {
            if (to.hasProperty(propName)) continue;
            to.setProperty(from.getProperty(propName).clone());
        }
    }

    public Map<String, Property> getProperties();

    default public Property getProperty(String name) {
        return this.getProperties().get(name);
    }

    default public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    default public boolean hasProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    default public void removeProperty(String name) {
        this.getProperties().remove(name);
    }

    default public Property setProperty(Property property) {
        this.getProperties().put(property.getName(), property);
        return property;
    }

    default public Iterator<Property> propertyIterator() {
        return this.getProperties().values().iterator();
    }
}

