/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;

public class Code
implements IWithProperties,
Cloneable {
    public static final String TYPE_NULL = "null";
    public static final String TYPE_BOLD = "bold";
    public static final String TYPE_ITALIC = "italic";
    public static final String TYPE_UNDERLINED = "underlined";
    public static final String TYPE_LB = "lb";
    public static final String TYPE_LINK = "link";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_COMMENT = "comment";
    public static final String TYPE_CDATA = "cdata";
    public static final String TYPE_XML_PROCESSING_INSTRUCTION = "processing-instruction";
    public static final String TYPE_REFERENCE = "ref";
    public static final String TYPE_ANNOTATION_ONLY = "_annotation_";
    public static final String TYPE_OKAPI_MARKER = "_okp-marker_";
    public static final String EXTENDED_CODE_TYPE_PREFIX = "x-";
    public static final String EXTENDED_CODE_TYPE_DELIMITER = ";";
    public static final String EXTENDED_CODE_TYPE_VALUE_DELIMITER = ":";
    private static final int DATA_DEFAULT_SIZE = 10;
    private static final int ANNOTATIONS_INITCAP = 1;
    protected static final int HASREF = 1;
    public static final int CLONEABLE = 2;
    public static final int DELETEABLE = 4;
    public static final int ADDED = 8;
    public static final int MERGED = 16;
    public static final int MARKER_MASKING = 32;
    public static final String SEP_CODEFIELD = "\u009c";
    public static final String SEP_CODE = "\u009d";
    public static final String SEP_CODEANNOTATIONKEY = "\u009e";
    public static final String SEP_CODEANNOTATIONVALUE = "\u009f";
    public static final String PROPERTIES = "PROPERTIES";
    protected TextFragment.TagType tagType;
    protected String originalId;
    protected int id = -1;
    protected String type;
    protected StringBuilder data;
    protected String mergedData;
    protected StringBuilder outerData;
    protected String displayText;
    protected int flag;
    protected LinkedHashMap<String, InlineAnnotation> inlineAnnotations;

    public static String codesToString(List<Code> list) {
        return Code.codesToString(list, false);
    }

    public static String codesToString(List<Code> list, boolean stripOuterData) {
        StringBuilder tmp = new StringBuilder();
        for (Code code : list) {
            StringJoiner sj = new StringJoiner(SEP_CODEFIELD, "", SEP_CODE).add(code.tagType.name()).add("" + code.id).add(code.type).add(code.data).add("" + code.flag);
            if (code.originalId != null) {
                sj.add(code.originalId);
            }
            sj.add(stripOuterData ? null : code.outerData).add(Code.annotationsToString(code.inlineAnnotations));
            tmp.append(sj.toString());
        }
        return tmp.toString();
    }

    public static boolean sameCodes(List<Code> codes1, List<Code> codes2) {
        if (codes1.size() != codes2.size()) {
            return false;
        }
        for (int i = 0; i < codes1.size(); ++i) {
            Code code1 = codes1.get(i);
            Code code2 = codes2.get(i);
            if (code1.id != code2.id) {
                return false;
            }
            if (code1.data == null || code1.data.toString().equals(code2.data.toString())) continue;
            return false;
        }
        return true;
    }

    public static int getIndex(List<Code> codes, boolean forClosing, int id) {
        if (codes == null) {
            return -1;
        }
        int i = 0;
        for (Code code : codes) {
            if (code.id == id) {
                if (forClosing) {
                    if (code.tagType == TextFragment.TagType.CLOSING) {
                        return i;
                    }
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private static String annotationsToString(LinkedHashMap<String, InlineAnnotation> map) {
        if (map == null || map.isEmpty()) {
            return TYPE_NULL;
        }
        StringBuilder tmp = new StringBuilder();
        for (String key : map.keySet()) {
            tmp.append(key).append(SEP_CODEANNOTATIONKEY);
            InlineAnnotation annotation = map.get(key);
            tmp.append(annotation == null ? "" : annotation.toString());
            tmp.append(SEP_CODEANNOTATIONVALUE);
        }
        return tmp.toString();
    }

    public static List<Code> stringToCodes(String data) {
        ArrayList<Code> list = new ArrayList<Code>();
        if (data != null) {
            String[] tmpCodes;
            for (String tmp : tmpCodes = data.split(SEP_CODE, 0)) {
                if (tmp.length() == 0) continue;
                String[] tmpFields = tmp.split(SEP_CODEFIELD, -1);
                Code code = new Code(TextFragment.TagType.valueOf(tmpFields[0]), tmpFields[2], tmpFields[3]);
                code.id = Integer.parseInt(tmpFields[1]);
                code.flag = Integer.parseInt(tmpFields[4]);
                int outerDataIndex = 5;
                int annotationIndex = 6;
                if (tmpFields.length >= 8) {
                    ++outerDataIndex;
                    ++annotationIndex;
                    if (!tmpFields[5].equals(TYPE_NULL)) {
                        code.originalId = tmpFields[5];
                    }
                }
                if (!tmpFields[outerDataIndex].equals(TYPE_NULL)) {
                    if (code.outerData == null) {
                        code.outerData = new StringBuilder(10);
                    }
                    code.outerData.setLength(0);
                    code.outerData.append(tmpFields[outerDataIndex]);
                }
                code.inlineAnnotations = tmpFields.length > annotationIndex ? Code.stringToAnnotations(tmpFields[annotationIndex]) : null;
                list.add(code);
            }
        }
        return list;
    }

    private static LinkedHashMap<String, InlineAnnotation> stringToAnnotations(String data) {
        String[] tmpEntries;
        if (data == null || data.length() == 0 || TYPE_NULL.equals(data)) {
            return null;
        }
        LinkedHashMap<String, InlineAnnotation> map = new LinkedHashMap<String, InlineAnnotation>(1);
        for (String tmp : tmpEntries = data.split(SEP_CODEANNOTATIONVALUE, -1)) {
            InlineAnnotation annotation;
            if (tmp.length() == 0) continue;
            String[] tmpPair = tmp.split(SEP_CODEANNOTATIONKEY, -1);
            if (tmpPair.length > 1) {
                switch (tmpPair[0]) {
                    case "generic": {
                        annotation = new GenericAnnotations();
                        break;
                    }
                    case "PROPERTIES": {
                        annotation = new GenericAnnotation();
                        break;
                    }
                    default: {
                        annotation = new InlineAnnotation();
                    }
                }
                annotation.fromString(tmpPair[1]);
            } else {
                annotation = null;
            }
            map.put(tmpPair[0], annotation);
        }
        return map;
    }

    public Code() {
        this(null);
    }

    public Code(TextFragment.TagType tagType, String type, String data) {
        this.tagType = tagType;
        this.flag = 0;
        this.type = type == null ? TYPE_NULL : type;
        this.setData(data);
    }

    public Code(TextFragment.TagType tagType, String type) {
        this(tagType, type, "");
    }

    public Code(String type) {
        this(null, type, "");
    }

    public void append(String data) {
        if (data != null) {
            this.data.append(data);
            if (data.contains("[#$")) {
                this.setReferenceFlag(true);
            }
        }
    }

    public void appendOuterData(String outerData) {
        if (outerData == null) {
            return;
        }
        if (this.outerData == null) {
            this.outerData = new StringBuilder(10);
        }
        this.outerData.append(outerData);
    }

    public void appendReference(String id) {
        this.data.append(TextFragment.makeRefMarker(id));
        this.setReferenceFlag(true);
    }

    public void appendReference(String id, String propertyName) {
        this.data.append(TextFragment.makeRefMarker(id, propertyName));
        this.setReferenceFlag(true);
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean hasAnnotation() {
        return this.inlineAnnotations != null && this.inlineAnnotations.size() > 0;
    }

    public boolean hasAnnotation(String type) {
        if (this.inlineAnnotations == null) {
            return false;
        }
        return this.inlineAnnotations.containsKey(type);
    }

    public boolean hasOnlyAnnotation() {
        if (this.inlineAnnotations == null) {
            return false;
        }
        return this.type.equals(TYPE_ANNOTATION_ONLY);
    }

    public boolean hasData() {
        return this.data.length() > 0;
    }

    public boolean hasOriginalId() {
        return !Util.isEmpty(this.originalId);
    }

    public boolean hasOuterData() {
        return !Util.isEmpty(this.outerData);
    }

    public Code clone() {
        Code newCode = new Code(this.tagType, this.type, this.data == null ? "" : this.data.toString());
        newCode.id = this.id;
        newCode.originalId = this.originalId;
        newCode.outerData = this.outerData == null ? null : new StringBuilder(this.outerData);
        newCode.displayText = this.displayText;
        newCode.flag = this.flag;
        newCode.mergedData = this.mergedData;
        if (this.inlineAnnotations != null) {
            newCode.inlineAnnotations = new LinkedHashMap();
            for (String type : this.inlineAnnotations.keySet()) {
                if (PROPERTIES.equals(type)) continue;
                InlineAnnotation annot = this.inlineAnnotations.get(type);
                if (annot == null) {
                    newCode.inlineAnnotations.put(type, null);
                    continue;
                }
                newCode.inlineAnnotations.put(type, annot.clone());
            }
        }
        IWithProperties.copy(this, newCode);
        return newCode;
    }

    public TextFragment.TagType getTagType() {
        return this.tagType;
    }

    public void setTagType(TextFragment.TagType value) {
        this.tagType = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value == null ? TYPE_NULL : value;
    }

    public String getData() {
        return this.data.toString();
    }

    public void setData(String value) {
        if (this.data == null) {
            this.data = new StringBuilder(10);
        } else {
            this.data.setLength(0);
        }
        this.setReferenceFlag(false);
        this.append(value);
    }

    public String getMergedData() {
        return this.mergedData;
    }

    public void setMergedData(String mergedData) {
        if (mergedData != null) {
            this.setMerged(true);
        }
        this.mergedData = mergedData;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int index) {
        this.id = index;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public boolean hasReference() {
        return (this.flag & 1) == 1;
    }

    public void setReferenceFlag(boolean value) {
        this.flag = value ? (this.flag |= 1) : (this.flag &= 0xFFFFFFFE);
    }

    public void setOuterData(String value) {
        if (value == null) {
            this.outerData = null;
            return;
        }
        if (this.outerData == null) {
            this.outerData = new StringBuilder(10);
        } else {
            this.outerData.setLength(0);
        }
        this.outerData.append(value);
    }

    public String getOuterData() {
        if (this.outerData != null) {
            return this.outerData.toString();
        }
        return this.data.toString();
    }

    public boolean isCloneable() {
        return (this.flag & 2) == 2;
    }

    public void setCloneable(boolean value) {
        this.flag = value ? (this.flag |= 2) : (this.flag &= 0xFFFFFFFD);
    }

    public boolean isDeleteable() {
        return (this.flag & 4) == 4;
    }

    public void setDeleteable(boolean value) {
        this.flag = value ? (this.flag |= 4) : (this.flag &= 0xFFFFFFFB);
    }

    public boolean isAdded() {
        return (this.flag & 8) == 8;
    }

    public void setAdded(boolean value) {
        this.flag = value ? (this.flag |= 8) : (this.flag &= 0xFFFFFFF7);
    }

    public boolean isMerged() {
        return (this.flag & 0x10) == 16;
    }

    public void setMerged(boolean value) {
        this.flag = value ? (this.flag |= 0x10) : (this.flag &= 0xFFFFFFEF);
    }

    public boolean isMarkerMasking() {
        return (this.flag & 0x20) == 32;
    }

    public void setMarkerMasking(boolean value) {
        this.flag = value ? (this.flag |= 0x20) : (this.flag &= 0xFFFFFFDF);
    }

    public void setAnnotation(String type, InlineAnnotation annotation) {
        if (this.inlineAnnotations == null) {
            this.inlineAnnotations = new LinkedHashMap(1);
        }
        this.inlineAnnotations.put(type, annotation);
    }

    public InlineAnnotation getAnnotation(String type) {
        if (this.inlineAnnotations == null) {
            return null;
        }
        return this.inlineAnnotations.get(type);
    }

    public Set<String> getAnnotationsTypes() {
        if (this.inlineAnnotations == null) {
            return Collections.emptySet();
        }
        return this.inlineAnnotations.keySet();
    }

    public void removeAnnotations() {
        if (this.inlineAnnotations != null) {
            this.inlineAnnotations.clear();
            this.inlineAnnotations = null;
        }
    }

    public void removeAnnotation(String type) {
        if (this.inlineAnnotations != null) {
            this.inlineAnnotations.remove(type);
        }
    }

    public GenericAnnotations getGenericAnnotations() {
        return (GenericAnnotations)this.getAnnotation("generic");
    }

    public String getGenericAnnotationString(String type, String fieldName) {
        GenericAnnotations anns = this.getGenericAnnotations();
        if (anns == null) {
            return null;
        }
        GenericAnnotation ann = anns.getFirstAnnotation(type);
        if (ann == null) {
            return null;
        }
        return ann.getString(fieldName);
    }

    public void setDisplayText(String text) {
        this.displayText = text;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    @Override
    public Property getProperty(String name) {
        if (this.hasProperty(name)) {
            GenericAnnotation a = (GenericAnnotation)this.inlineAnnotations.get(PROPERTIES);
            return new Property(name, a.getString(name));
        }
        return null;
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.inlineAnnotations == null || this.inlineAnnotations.isEmpty()) {
            return false;
        }
        GenericAnnotation a = (GenericAnnotation)this.inlineAnnotations.get(PROPERTIES);
        if (a == null) {
            return false;
        }
        return a.getString(name) != null;
    }

    @Override
    public void removeProperty(String name) {
        if (this.inlineAnnotations == null || this.inlineAnnotations.isEmpty()) {
            return;
        }
        GenericAnnotation a = (GenericAnnotation)this.inlineAnnotations.get(PROPERTIES);
        if (a != null) {
            a.remove(name);
        }
    }

    @Override
    public Property setProperty(Property property) {
        if (this.inlineAnnotations == null) {
            this.inlineAnnotations = new LinkedHashMap(1);
        }
        GenericAnnotation ga = (GenericAnnotation)this.inlineAnnotations.computeIfAbsent(PROPERTIES, GenericAnnotation::new);
        ga.setString(property.getName(), property.getValue());
        return property;
    }

    @Override
    public Map<String, Property> getProperties() {
        if (this.inlineAnnotations == null || this.inlineAnnotations.isEmpty() || !this.inlineAnnotations.containsKey(PROPERTIES)) {
            return Collections.EMPTY_MAP;
        }
        GenericAnnotation ga = (GenericAnnotation)this.inlineAnnotations.get(PROPERTIES);
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        for (String n : ga.getNames()) {
            properties.put(n, new Property(n, ga.getString(n)));
        }
        return properties;
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.inlineAnnotations == null || this.inlineAnnotations.isEmpty() || !this.inlineAnnotations.containsKey(PROPERTIES)) {
            return Collections.EMPTY_SET;
        }
        GenericAnnotation a = (GenericAnnotation)this.inlineAnnotations.get(PROPERTIES);
        if (a != null) {
            return a.getNames();
        }
        return Collections.EMPTY_SET;
    }
}

