/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.layerprovider.ILayerProvider;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TargetPropertiesAnnotation;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class SubFilterSkeletonWriter
implements ISkeletonWriter {
    public static final String GET_OUTPUT_TOKEN_ID = "#$GET_SFSW_OUTPUT$#";
    private ISkeletonWriter skelWriter;
    private IEncoder parentEncoder;
    private String startResourceId;
    private Set<String> handledTextUnitIds;
    private StringBuilder sourceOutput;
    private TargetOutputs targetOutputs;
    private LocaleId targetLocaleId;

    public SubFilterSkeletonWriter(StartSubfilter resource) {
        this(resource.getFilterWriter().getSkeletonWriter(), resource.getParentEncoder(), resource.getId(), new HashSet<String>(), new StringBuilder(), new TargetOutputs.Default(new LinkedHashMap<LocaleId, StringBuilder>()));
    }

    public SubFilterSkeletonWriter(ISkeletonWriter skelWriter, IEncoder parentEncoder, String startResourceId, Set<String> handledTextUnitIds, StringBuilder sourceOutput, TargetOutputs targetOutputs) {
        this.skelWriter = skelWriter;
        this.parentEncoder = parentEncoder;
        this.startResourceId = startResourceId;
        this.handledTextUnitIds = handledTextUnitIds;
        this.sourceOutput = sourceOutput;
        this.targetOutputs = targetOutputs;
    }

    @Override
    public void close() {
        this.skelWriter.close();
    }

    public String getStartResourceId() {
        return this.startResourceId;
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        this.targetLocaleId = outputLocale;
        String s = this.skelWriter.processStartDocument(outputLocale, outputEncoding, layer, encoderManager, resource);
        this.sourceOutput.append(s);
        this.targetOutputs.add(outputLocale, new StringBuilder(s));
        return "";
    }

    @Override
    public String processEndDocument(Ending resource) {
        if (GET_OUTPUT_TOKEN_ID.equals(resource.getId())) {
            Iterator<IAnnotation> iterator = resource.getAnnotations().iterator();
            if (!iterator.hasNext()) {
                return this.parentEncoder == null ? this.sourceOutput.toString() : this.parentEncoder.encode(this.sourceOutput.toString(), EncoderContext.TEXT);
            }
            IAnnotation annotation = iterator.next();
            if (!(annotation instanceof TargetPropertiesAnnotation)) {
                throw new OkapiException("Unexpected annotation found: ".concat(annotation.toString()));
            }
            if (1 != ((TargetPropertiesAnnotation)annotation).getLocales().size()) {
                throw new OkapiException("Unsupported number of target locales provided: " + ((TargetPropertiesAnnotation)annotation).getLocales().size());
            }
            LocaleId localeId = new ArrayList<LocaleId>(((TargetPropertiesAnnotation)annotation).getLocales()).get(0);
            return this.parentEncoder == null ? this.targetOutputs.outputFor(localeId).toString() : this.parentEncoder.encode(this.targetOutputs.outputFor(localeId).toString(), EncoderContext.TEXT);
        }
        String s = this.skelWriter.processEndDocument(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    @Override
    public String processStartSubDocument(StartSubDocument resource) {
        String s = this.skelWriter.processStartSubDocument(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    @Override
    public String processEndSubDocument(Ending resource) {
        String s = this.skelWriter.processEndSubDocument(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    @Override
    public String processStartGroup(StartGroup resource) {
        String s = this.skelWriter.processStartGroup(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    @Override
    public String processEndGroup(Ending resource) {
        String s = this.skelWriter.processEndGroup(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        if (resource.getTargetLocales().isEmpty() && !this.handledTextUnitIds.contains(resource.getId())) {
            resource.setTarget(this.targetLocaleId, resource.getSource());
        }
        Map<LocaleId, TextContainer> targetTextContainers = resource.getTargetLocales().stream().collect(Collectors.toMap(l -> l, l -> resource.getTarget((LocaleId)l)));
        targetTextContainers.keySet().forEach(l -> resource.removeTarget((LocaleId)l));
        targetTextContainers.forEach((l, tc) -> {
            resource.setTarget((LocaleId)l, (TextContainer)tc);
            this.targetOutputs.appendTo((LocaleId)l, this.skelWriter.processTextUnit(resource));
            resource.removeTarget((LocaleId)l);
        });
        if (!this.handledTextUnitIds.contains(resource.getId())) {
            this.sourceOutput.append(this.skelWriter.processTextUnit(resource));
        }
        targetTextContainers.forEach((l, tc) -> resource.setTarget((LocaleId)l, (TextContainer)tc));
        this.handledTextUnitIds.add(resource.getId());
        return "";
    }

    @Override
    public String processDocumentPart(DocumentPart resource) {
        String s = this.skelWriter.processDocumentPart(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    @Override
    public String processStartSubfilter(StartSubfilter resource) {
        String s = this.skelWriter.processStartSubfilter(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    @Override
    public String processEndSubfilter(EndSubfilter resource) {
        String s = this.skelWriter.processEndSubfilter(resource);
        this.sourceOutput.append(s);
        this.targetOutputs.appendToAll(s);
        return "";
    }

    public String getEncodedOutput(LocaleId locToUse) {
        Ending ending = new Ending(GET_OUTPUT_TOKEN_ID);
        if (null != locToUse) {
            TargetPropertiesAnnotation a = new TargetPropertiesAnnotation();
            a.set(locToUse, Collections.emptyMap());
            ending.setAnnotation(a);
        }
        return this.processEndDocument(ending);
    }

    public SubFilterSkeletonWriter setOptions(LocaleId outputLocale, String outputEncoding, StartSubfilter startSubfilter, ILayerProvider layer) {
        StartDocument sfStartDoc = startSubfilter.getStartDoc();
        IFilterWriter sfFilterWriter = sfStartDoc.getFilterWriter();
        EncoderManager sfEncoderManager = sfFilterWriter.getEncoderManager();
        this.processStartDocument(outputLocale, outputEncoding, layer, sfEncoderManager, startSubfilter.getStartDoc());
        return this;
    }

    public ISkeletonWriter getSkelWriter() {
        return this.skelWriter;
    }

    protected void setSkelWriter(ISkeletonWriter skelWriter) {
        this.skelWriter = skelWriter;
    }

    protected IEncoder getParentEncoder() {
        return this.parentEncoder;
    }

    protected void setParentEncoder(IEncoder parentEncoder) {
        this.parentEncoder = parentEncoder;
    }

    public static interface TargetOutputs {
        public void add(LocaleId var1, StringBuilder var2);

        public void appendTo(LocaleId var1, String var2);

        public void appendToAll(String var1);

        public StringBuilder outputFor(LocaleId var1);

        public static final class Default
        implements TargetOutputs {
            private static final String UNEXPECTED_TARGET_OUTPUT_REQUESTED_FOR = "Unexpected target output requested for ";
            private final Map<LocaleId, StringBuilder> outputs;

            public Default(Map<LocaleId, StringBuilder> outputs) {
                this.outputs = outputs;
            }

            @Override
            public void add(LocaleId localeId, StringBuilder stringBuilder) {
                this.outputs.put(localeId, stringBuilder);
            }

            @Override
            public void appendTo(LocaleId localeId, String text) {
                if (!this.outputs.containsKey(localeId)) {
                    throw new OkapiException(UNEXPECTED_TARGET_OUTPUT_REQUESTED_FOR.concat(localeId.toString()));
                }
                this.outputs.get(localeId).append(text);
            }

            @Override
            public void appendToAll(String text) {
                this.outputs.values().forEach(sb -> sb.append(text));
            }

            @Override
            public StringBuilder outputFor(LocaleId localeId) {
                if (!this.outputs.containsKey(localeId)) {
                    throw new OkapiException(UNEXPECTED_TARGET_OUTPUT_REQUESTED_FOR.concat(localeId.toString()));
                }
                return this.outputs.get(localeId);
            }
        }
    }
}

