/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.DefaultEncoder;
import net.sf.okapi.common.encoder.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownEncoder
extends DefaultEncoder {
    private final Logger LOGGER = LoggerFactory.getLogger(MarkdownEncoder.class);
    private boolean escapeSpecialCharacters = false;
    private String charactersToEscape = "*_`{}[]<>()#+\\-.!|";
    private IParameters params;
    public static final String DEFAULT_CHARACTERS_TO_ESCAPE = "*_`{}[]<>()#+\\-.!|";
    private Pattern escapingRegex;

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.params = params;
        if (params != null) {
            this.escapeSpecialCharacters = params.getBoolean("unescapeBackslashCharacters");
            this.charactersToEscape = params.getString("charactersToEscape");
            if (this.escapeSpecialCharacters) {
                this.escapingRegex = this.buildEscapingRegex();
            }
        }
        this.setLineBreak(lineBreak);
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        String result = text.replace("\n", this.getLineBreak());
        if (this.escapeSpecialCharacters) {
            return result.replaceAll(this.escapingRegex.pattern(), "\\\\$1");
        }
        return result;
    }

    @Override
    public String encode(char value, EncoderContext context) {
        String result = String.valueOf(value).replace("\n", this.getLineBreak());
        if (this.escapeSpecialCharacters) {
            return result.replaceAll(this.escapingRegex.pattern(), "\\\\$1");
        }
        return result;
    }

    @Override
    public String encode(int value, EncoderContext context) {
        String result = Character.isSupplementaryCodePoint(value) ? new String(Character.toChars(value)).replace("\n", this.getLineBreak()) : String.valueOf((char)value).replace("\n", this.getLineBreak());
        if (this.escapeSpecialCharacters) {
            return result.replaceAll(this.escapingRegex.pattern(), "\\\\$1");
        }
        return result;
    }

    private Pattern buildEscapingRegex() {
        try {
            return Pattern.compile("([" + Pattern.quote(this.charactersToEscape) + "])");
        }
        catch (PatternSyntaxException e) {
            this.LOGGER.warn("Invalid charactersToEscape value: {}", (Object)this.charactersToEscape);
            return Pattern.compile("([" + Pattern.quote(DEFAULT_CHARACTERS_TO_ESCAPE) + "])");
        }
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }
}

