/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BOMAwareInputStream
extends InputStream
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4;
    private PushbackInputStream initStream;
    private InputStream input;
    private String defaultEncoding;
    private String detectedEncoding;
    private int bomSize;
    private boolean hasUTF8BOM;
    private boolean autoDetected;

    public BOMAwareInputStream(InputStream input, String defaultEncoding) {
        this.input = input;
        this.defaultEncoding = defaultEncoding;
        this.bomSize = 0;
        this.hasUTF8BOM = false;
        this.autoDetected = false;
    }

    public String detectEncoding() throws IOException {
        int unread;
        this.initStream = new PushbackInputStream(this.input, 4);
        byte[] bom = new byte[4];
        int n = this.initStream.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.detectedEncoding = "UTF-8";
            this.bomSize = 3;
            this.hasUTF8BOM = true;
            this.autoDetected = true;
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            this.detectedEncoding = "UTF-16BE";
            this.autoDetected = true;
            this.bomSize = 2;
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.detectedEncoding = "UTF-32LE";
            this.autoDetected = true;
            this.bomSize = 4;
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2) {
            this.detectedEncoding = "UTF-16LE";
            this.autoDetected = true;
            this.bomSize = 2;
            unread = n - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            this.detectedEncoding = "UTF-32BE";
            this.autoDetected = true;
            this.bomSize = 4;
            unread = n - 4;
        } else {
            this.detectedEncoding = this.defaultEncoding;
            this.bomSize = 0;
            unread = n;
        }
        if (unread > 0) {
            this.initStream.unread(bom, n - unread, unread);
        }
        return this.detectedEncoding;
    }

    public String getDetectedEncoding() {
        return this.detectedEncoding;
    }

    public boolean autoDtected() {
        return this.autoDetected;
    }

    public int getBOMSize() {
        return this.bomSize;
    }

    public boolean hasUTF8BOM() {
        return this.hasUTF8BOM;
    }

    @Override
    public int read() throws IOException {
        return this.initStream.read();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.initStream != null) {
            this.initStream.close();
        }
    }
}

