/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml;

import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlEventBuilder
extends EventBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private InlineCodeFinder codeFinder = null;
    private EncoderManager encoderManager;

    public YamlEventBuilder(String rootId, IFilter subFilter) {
        super(rootId, subFilter);
        this.encoderManager = subFilter.getEncoderManager();
    }

    @Override
    protected ITextUnit postProcessTextUnit(ITextUnit textUnit) {
        TextFragment text = textUnit.getSource().getFirstContent();
        text.setCodedText(text.getCodedText());
        if (this.codeFinder != null) {
            this.encoderManager.updateEncoder(textUnit.getMimeType());
            this.codeFinder.process(text);
        }
        text.setCodedText(text.getCodedText());
        return textUnit;
    }

    public void setCodeFinder(InlineCodeFinder codeFinder) {
        this.codeFinder = codeFinder;
    }
}

