/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSProvenance {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String person;
    private String org;
    private String tool;
    private String revPerson;
    private String revOrg;
    private String revTool;
    private String provRef;

    public ITSProvenance(Iterator<Attribute> attrs) {
        block30: while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            String prefix = attr.getName().getPrefix();
            String name = attr.getName().getLocalPart();
            String value = attr.getValue();
            if (!prefix.isEmpty() && !prefix.equals("its")) {
                name = prefix + ":" + name;
            }
            switch (name) {
                case "person": {
                    this.setPerson(value);
                    continue block30;
                }
                case "personRef": {
                    this.setPerson("REF:" + value);
                    continue block30;
                }
                case "org": {
                    this.setOrg(value);
                    continue block30;
                }
                case "orgRef": {
                    this.setOrg("REF:" + value);
                    continue block30;
                }
                case "tool": {
                    this.setTool(value);
                    continue block30;
                }
                case "toolRef": {
                    this.setTool("REF:" + value);
                    continue block30;
                }
                case "revPerson": {
                    this.setRevPerson(value);
                    continue block30;
                }
                case "revPersonRef": {
                    this.setRevPerson("REF:" + value);
                    continue block30;
                }
                case "revOrg": {
                    this.setRevOrg(value);
                    continue block30;
                }
                case "revOrgRef": {
                    this.setRevOrg("REF:" + value);
                    continue block30;
                }
                case "revTool": {
                    this.setRevTool(value);
                    continue block30;
                }
                case "revToolRef": {
                    this.setRevTool("REF:" + value);
                    continue block30;
                }
                case "provRef": {
                    this.provRef = value;
                    continue block30;
                }
            }
            this.logger.warn("Unrecognized ITS Provenance attribute: {}", (Object)name);
        }
    }

    public ITSProvenance(String person, String org, String tool, String revPerson, String revOrg, String revTool, String provRef) {
        this();
        this.setPerson(person);
        this.setOrg(org);
        this.setTool(tool);
        this.setRevPerson(revPerson);
        this.setRevOrg(revOrg);
        this.setRevTool(revTool);
        this.setProvRef(provRef);
    }

    public ITSProvenance() {
    }

    public String getPerson() {
        return this.person;
    }

    public final void setPerson(String person) {
        if (this.person != null) {
            this.logger.warn("Provenance person redefined from \"{}\" to \"{}\"", (Object)this.person, (Object)person);
        }
        this.person = person;
    }

    public String getOrg() {
        return this.org;
    }

    public final void setOrg(String org) {
        if (this.org != null) {
            this.logger.warn("Provenance org redefined from \"{}\" to \"{}\"", (Object)this.org, (Object)org);
        }
        this.org = org;
    }

    public String getTool() {
        return this.tool;
    }

    public final void setTool(String tool) {
        if (this.tool != null) {
            this.logger.warn("Provenance tool redefined from \"{}\" to \"{}\"", (Object)this.tool, (Object)tool);
        }
        this.tool = tool;
    }

    public String getRevPerson() {
        return this.revPerson;
    }

    public final void setRevPerson(String revPerson) {
        if (this.revPerson != null) {
            this.logger.warn("Provenance revPerson redefined from \"{}\" to \"{}\"", (Object)this.revPerson, (Object)revPerson);
        }
        this.revPerson = revPerson;
    }

    public String getRevOrg() {
        return this.revOrg;
    }

    public final void setRevOrg(String revOrg) {
        if (this.revOrg != null) {
            this.logger.warn("Provenance revOrg redefined from \"{}\" to \"{}\"", (Object)this.revOrg, (Object)revOrg);
        }
        this.revOrg = revOrg;
    }

    public String getRevTool() {
        return this.revTool;
    }

    public final void setRevTool(String revTool) {
        if (this.revTool != null) {
            this.logger.warn("Provenance revTool redefined from \"{}\" to \"{}\"", (Object)this.revTool, (Object)revTool);
        }
        this.revTool = revTool;
    }

    public String getProvRef() {
        return this.provRef;
    }

    public final void setProvRef(String provRef) {
        this.provRef = provRef;
    }
}

