/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit;

import net.sf.okapi.common.Base64;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.exceptions.OkapiIOException;
import org.w3c.dom.Element;

public class MergingInfo
implements IAnnotation {
    private static final String INVALIDVALUE = "Invalid value for attribute '%s'.";
    private int docId;
    private String extractionType;
    private String relativeInputPath;
    private String filterId;
    private String filterParameters;
    private String inputEncoding;
    private String relativeTargetPath;
    private String targetEncoding;
    private String resourceId;
    private boolean selected;
    private boolean useSkeleton;

    public MergingInfo() {
    }

    public MergingInfo(int docId, String extractionType, String relativeInputPath, String filterId, String filterParameters, String inputEncoding, String relativeTargetPath, String targetEncoding) {
        this.docId = docId;
        this.extractionType = extractionType;
        this.relativeInputPath = relativeInputPath;
        this.filterId = filterId;
        this.filterParameters = filterParameters;
        this.inputEncoding = inputEncoding;
        this.relativeTargetPath = relativeTargetPath;
        this.targetEncoding = targetEncoding;
        this.useSkeleton = false;
        this.selected = true;
    }

    public int getDocId() {
        return this.docId;
    }

    public String getExtractionType() {
        return this.extractionType;
    }

    public boolean getUseSkeleton() {
        return this.useSkeleton;
    }

    public void setUseSkeleton(boolean useSkeleton) {
        this.useSkeleton = useSkeleton;
    }

    public String getRelativeInputPath() {
        return this.relativeInputPath;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public String getFilterParameters() {
        return this.filterParameters;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String getRelativeTargetPath() {
        return this.relativeTargetPath;
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String writeToXML(String elementQName, boolean base64) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<%s xml:space=\"preserve\" docId=\"%d\" extractionType=\"%s\" relativeInputPath=\"%s\" filterId=\"%s\" inputEncoding=\"%s\" relativeTargetPath=\"%s\" targetEncoding=\"%s\" selected=\"%s\"", elementQName, this.docId, this.extractionType, Util.escapeToXML(this.relativeInputPath, 3, false, null).replace('\\', '/'), this.filterId, this.inputEncoding, Util.escapeToXML(this.relativeTargetPath, 3, false, null).replace('\\', '/'), this.targetEncoding, this.selected ? "1" : "0"));
        if (!Util.isEmpty(this.resourceId)) {
            sb.append(String.format(" resourceId=\"%s\"", this.resourceId));
        }
        if (this.useSkeleton) {
            sb.append(" useSkeleton=\"yes\"");
        }
        if (this.filterParameters == null) {
            sb.append(" />");
        } else {
            String tmp = base64 ? Base64.encodeString(this.filterParameters) : Util.escapeToXML(this.filterParameters, 0, false, null);
            sb.append(">" + tmp + String.format("</%s>", elementQName));
        }
        return sb.toString();
    }

    public static MergingInfo readFromXML(Element element) {
        MergingInfo info = new MergingInfo();
        String tmp = element.getAttribute("docId");
        if (tmp.isEmpty()) {
            throw new OkapiIOException(String.format(INVALIDVALUE, "docId"));
        }
        try {
            info.docId = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw new OkapiIOException(String.format(INVALIDVALUE, "docId"));
        }
        tmp = element.getAttribute("extractionType");
        if (tmp.isEmpty()) {
            throw new OkapiIOException(String.format(INVALIDVALUE, "extractionType"));
        }
        info.extractionType = tmp;
        boolean noExtraction = tmp.equals("none");
        tmp = element.getAttribute("relativeInputPath");
        if (tmp.isEmpty()) {
            throw new OkapiIOException(String.format(INVALIDVALUE, "relativeInputPath"));
        }
        info.relativeInputPath = tmp;
        tmp = element.getAttribute("filterId");
        if (tmp.isEmpty() && !noExtraction) {
            throw new OkapiIOException(String.format(INVALIDVALUE, "filterId"));
        }
        info.filterId = tmp;
        tmp = element.getAttribute("inputEncoding");
        if (tmp.isEmpty() && !noExtraction) {
            throw new OkapiIOException(String.format(INVALIDVALUE, "inputEncoding"));
        }
        info.inputEncoding = tmp;
        tmp = element.getAttribute("relativeTargetPath");
        if (tmp.isEmpty()) {
            throw new OkapiIOException(String.format(INVALIDVALUE, "relativeTargetPath"));
        }
        info.relativeTargetPath = tmp;
        tmp = element.getAttribute("targetEncoding");
        info.targetEncoding = tmp.isEmpty() && !noExtraction ? info.inputEncoding : tmp;
        tmp = element.getAttribute("selected");
        info.selected = tmp.isEmpty() ? true : !tmp.equals("0");
        tmp = element.getAttribute("resourceId");
        if (!tmp.isEmpty()) {
            info.resourceId = tmp;
        }
        info.useSkeleton = (tmp = element.getAttribute("useSkeleton")).isEmpty() ? false : tmp.equals("yes");
        tmp = Util.getTextContent(element);
        if (!tmp.isEmpty()) {
            if (!tmp.startsWith("#v")) {
                tmp = Base64.decodeString(tmp);
            }
            info.filterParameters = tmp;
        }
        return info;
    }

    @Override
    public String toString() {
        return String.format("docId=%d type=%s", this.docId, this.extractionType);
    }
}

