/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.po;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    public static final String PROTECTAPPROVED = "protectApproved";
    private static final String ALLOWEMPTYTARGET = "allowEmptyOutputTarget";
    private static final String BILINGUALMODE = "bilingualMode";
    private static final String MAKEID = "makeID";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String INCLUDECONTEXTINNOTE = "includeMsgContextInNote";
    private static final String SUBFILTER = "subfilter";
    private InlineCodeFinder codeFinder;
    private boolean wrapContent = true;
    private boolean outputGeneric = false;

    public boolean getBilingualMode() {
        return this.getBoolean(BILINGUALMODE);
    }

    public void setBilingualMode(boolean bilingualMode) {
        this.setBoolean(BILINGUALMODE, bilingualMode);
    }

    public boolean getProtectApproved() {
        return this.getBoolean(PROTECTAPPROVED);
    }

    public void setProtectApproved(boolean protectApproved) {
        this.setBoolean(PROTECTAPPROVED, protectApproved);
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public void setCodeFinder(InlineCodeFinder codeFinder) {
        this.codeFinder = codeFinder;
    }

    public boolean getMakeID() {
        return this.getBoolean(MAKEID);
    }

    public void setMakeID(boolean makeID) {
        this.setBoolean(MAKEID, makeID);
    }

    public boolean getWrapContent() {
        return this.wrapContent;
    }

    public void setWrapContent(boolean wrapContent) {
        this.wrapContent = wrapContent;
    }

    public boolean getOutputGeneric() {
        return this.outputGeneric;
    }

    public void setOutputGeneric(boolean outputGeneric) {
        this.outputGeneric = outputGeneric;
    }

    public boolean getAllowEmptyOutputTarget() {
        return this.getBoolean(ALLOWEMPTYTARGET);
    }

    public void setAllowEmptyOutputTarget(boolean allowEmptyOutputTarget) {
        this.setBoolean(ALLOWEMPTYTARGET, allowEmptyOutputTarget);
    }

    public boolean getIncludeMsgContextInNote() {
        return this.getBoolean(INCLUDECONTEXTINNOTE);
    }

    public void setIncludeMsgContextInNote(boolean includeMsgContextInNote) {
        this.setBoolean(INCLUDECONTEXTINNOTE, includeMsgContextInNote);
    }

    public String getSubfilter() {
        return this.getString(SUBFILTER);
    }

    public void setSubfilter(String subfilter) {
        this.setString(SUBFILTER, subfilter);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public void reset() {
        super.reset();
        this.setBilingualMode(true);
        this.setMakeID(true);
        this.setProtectApproved(false);
        this.setUseCodeFinder(true);
        this.setAllowEmptyOutputTarget(false);
        this.setSubfilter("");
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("%s, %d, {1}, \\n, \\r, \\t, etc.");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]");
        this.codeFinder.addRule("(\\\\r\\\\n)|\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("\\{\\d[^\\\\]*?\\}");
        this.setSimplifierRules(null);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

