/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import net.sf.okapi.filters.openxml.BlockPropertiesClarifier;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesClarifier;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface StylesClarifier {
    public void clarifyWith(ListIterator<MarkupComponent> var1);

    public static class Word
    implements StylesClarifier {
        private final BlockPropertiesClarifier.TablePropertiesClarifier tablePropertiesClarifier;
        private final BlockPropertiesClarifier.ParagraphPropertiesClarifier paragraphPropertiesClarifier;
        private final RunPropertiesClarifier runPropertiesClarifier;
        private final Set<String> clarifiableWordStyleTypes;

        Word(BlockPropertiesClarifier.TablePropertiesClarifier tablePropertiesClarifier, BlockPropertiesClarifier.ParagraphPropertiesClarifier paragraphPropertiesClarifier, RunPropertiesClarifier runPropertiesClarifier) {
            this(tablePropertiesClarifier, paragraphPropertiesClarifier, runPropertiesClarifier, new HashSet<String>(Arrays.asList(StyleType.TABLE.toString(), StyleType.PARAGRAPH.toString(), StyleType.CHARACTER.toString())));
        }

        Word(BlockPropertiesClarifier.TablePropertiesClarifier tablePropertiesClarifier, BlockPropertiesClarifier.ParagraphPropertiesClarifier paragraphPropertiesClarifier, RunPropertiesClarifier runPropertiesClarifier, Set<String> clarifiableWordStyleTypes) {
            this.tablePropertiesClarifier = tablePropertiesClarifier;
            this.paragraphPropertiesClarifier = paragraphPropertiesClarifier;
            this.runPropertiesClarifier = runPropertiesClarifier;
            this.clarifiableWordStyleTypes = clarifiableWordStyleTypes;
        }

        @Override
        public void clarifyWith(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isWordDocumentDefaultsStart(component)) {
                    this.clarifyWordDocumentDefaultsWith(iterator);
                    continue;
                }
                if (MarkupComponent.isWordStyleStart(component)) {
                    this.clarifyWordStyleWith((MarkupComponent.Start)component, iterator);
                    continue;
                }
                if (!MarkupComponent.isWordStylesEnd(component)) continue;
                break;
            }
        }

        private void clarifyWordDocumentDefaultsWith(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isWordParagraphPropertiesDefaultStart(component)) {
                    this.paragraphPropertiesClarifier.clarifyWith(iterator);
                    this.clarifiableWordStyleTypes.remove(StyleType.PARAGRAPH.toString());
                    continue;
                }
                if (MarkupComponent.isWordRunPropertiesDefaultStart(component)) {
                    this.clarifyDefaultRunPropertiesWith(iterator);
                    this.clarifiableWordStyleTypes.remove(StyleType.CHARACTER.toString());
                    continue;
                }
                if (!MarkupComponent.isWordDocumentDefaultsEnd(component)) continue;
                break;
            }
        }

        private void clarifyDefaultRunPropertiesWith(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isRunProperties(component)) {
                    iterator.set(this.runPropertiesClarifier.clarify((RunProperties)component));
                    continue;
                }
                if (!MarkupComponent.isWordRunPropertiesDefaultEnd(component)) continue;
                break;
            }
        }

        private void clarifyWordStyleWith(MarkupComponent.Start startComponent, ListIterator<MarkupComponent> iterator) {
            if (!startComponent.containsAttributeWithAnyOfValues("type", this.clarifiableWordStyleTypes) || !startComponent.containsAttributeWithAnyOfValues("default", XMLEventHelpers.booleanAttributeTrueValues())) {
                return;
            }
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isParagraphBlockProperties(component)) {
                    iterator.previous();
                    this.paragraphPropertiesClarifier.clarifyWith(iterator);
                    continue;
                }
                if (MarkupComponent.isRunProperties(component)) {
                    iterator.set(this.runPropertiesClarifier.clarify((RunProperties)component));
                    continue;
                }
                if (MarkupComponent.isTableBlockProperties(component)) {
                    iterator.previous();
                    this.tablePropertiesClarifier.clarifyWith(iterator);
                    continue;
                }
                if (!MarkupComponent.isWordStyleEnd(component)) continue;
                break;
            }
        }
    }
}

