/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.NotesMasterFragments;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PresentationFragments;
import net.sf.okapi.filters.openxml.PresentationSlide;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPart;
import net.sf.okapi.filters.openxml.SlidablePart;
import net.sf.okapi.filters.openxml.SlideFragments;
import net.sf.okapi.filters.openxml.SlideMasterFragments;
import net.sf.okapi.filters.openxml.SlideTemplateFragments;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class PowerpointDocument
implements Document {
    private static final String SLIDE_MASTER = "/slideMaster";
    private static final String SLIDE_LAYOUT = "/slideLayout";
    private static final String COMMENTS = "/comments";
    private static final String NOTES_SLIDE = "/notesSlide";
    private static final String NOTES_MASTER = "/notesMaster";
    private static final String CHART = "/chart";
    private static final String DIAGRAM_DATA = "/diagramData";
    private static final Pattern RELS_NAME_PATTERN = Pattern.compile(".+slide\\d+\\.xml\\.rels");
    private Matcher relsNameMatcher = RELS_NAME_PATTERN.matcher("").reset();
    private final Document.General generalDocument;
    private PresentationFragments presentationFragments;
    private Enumeration<? extends ZipEntry> entries;
    private Map<String, SlideFragments> slideMasterFragmentsByName;
    private Map<String, SlideFragments> slideLayoutFragmentsByName;
    private Map<String, SlideFragments> slideFragmentsByName;
    private Map<String, SlideFragments> notesMasterFragmentsByName;
    private Map<String, SlideFragments> notesSlideFragmentsByName;
    private Map<String, String> slidesByComment;
    private Map<String, String> slidesByNote;
    private Map<String, String> slidesByChart;
    private Map<String, String> slidesByDiagramData;

    PowerpointDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.presentationFragments = this.presentationFragments();
        this.entries = this.entries();
        this.slideMasterFragmentsByName = this.slideMasterFragments();
        this.slideLayoutFragmentsByName = this.slideLayoutFragments();
        this.slideFragmentsByName = this.slideFragments();
        this.notesMasterFragmentsByName = this.notesMasterFragments();
        this.notesSlideFragmentsByName = this.notesSlideFragments();
        this.slidesByComment = this.comments();
        this.slidesByNote = this.notes();
        this.slidesByChart = this.charts();
        this.slidesByDiagramData = this.diagramDatas();
        return this.generalDocument.startDocumentEvent();
    }

    private PresentationFragments presentationFragments() throws IOException, XMLStreamException {
        PresentationFragments.Default pf = new PresentationFragments.Default(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.relationshipsFor(this.generalDocument.mainPartName()));
        try (Reader reader = this.generalDocument.getPartReader(this.generalDocument.mainPartName());){
            pf.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        return pf;
    }

    private Enumeration<? extends ZipEntry> entries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.generalDocument.entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        entryList.sort(new ZipEntryComparator(this.reorderedPartNames()));
        return Collections.enumeration(entryList);
    }

    private List<String> reorderedPartNames() throws IOException, XMLStreamException {
        LinkedList<String> names = new LinkedList<String>();
        for (String slideName : this.presentationFragments.slideNames()) {
            names.add(slideName);
            if (!this.generalDocument.conditionalParameters().getReorderPowerpointNotesAndComments()) continue;
            String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
            names.addAll(this.slideRelationshipTargetsForType(slideName, namespaceUri.concat(NOTES_SLIDE)));
            names.addAll(this.slideRelationshipTargetsForType(slideName, namespaceUri.concat(COMMENTS)));
        }
        return names;
    }

    private List<String> slideRelationshipTargetsForType(String slideName, String typeUri) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(slideName).getRelByType(typeUri);
        return rels == null ? Collections.emptyList() : rels.stream().map(r -> r.target).collect(Collectors.toList());
    }

    private Map<String, SlideFragments> slideMasterFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideMasterFragments = new HashMap<String, SlideFragments>(this.presentationFragments.slideMasterNames().size());
        for (String name : this.presentationFragments.slideMasterNames()) {
            slideMasterFragments.put(name, this.slideMasterFragmentsOf(name));
        }
        return slideMasterFragments;
    }

    private SlideFragments slideMasterFragmentsOf(String partName) throws IOException, XMLStreamException {
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && SlideMasterFragments.SLD_MASTER.equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!SlideMasterFragments.SLD_MASTER.equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideMasterFragments slideTemplateFragments = new SlideMasterFragments(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory());
                slideTemplateFragments.readWith(eventReader);
                SlideMasterFragments slideMasterFragments = slideTemplateFragments;
                return slideMasterFragments;
            }
        }
        return new SlideTemplateFragments.Empty();
    }

    private Map<String, SlideFragments> slideLayoutFragments() throws IOException, XMLStreamException {
        List<String> slideLayoutNames = this.slideLayoutNames();
        HashMap<String, SlideFragments> slideLayoutFragments = new HashMap<String, SlideFragments>(slideLayoutNames.size());
        for (String name : slideLayoutNames) {
            slideLayoutFragments.put(name, this.slideLayoutFragmentsOf(name));
        }
        return slideLayoutFragments;
    }

    private List<String> slideLayoutNames() throws IOException, XMLStreamException {
        ArrayList<String> layouts = new ArrayList<String>();
        String typeUri = this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_LAYOUT);
        for (String slideName : this.presentationFragments.slideNames()) {
            List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(slideName).getRelByType(typeUri);
            if (null == rels || rels.isEmpty()) continue;
            layouts.add(rels.get((int)0).target);
        }
        return layouts;
    }

    private SlideFragments slideLayoutFragmentsOf(String partName) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(partName).getRelByType(this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_MASTER));
        SlideTemplateFragments.Empty slideMasterFragments = null != rels && !rels.isEmpty() && this.slideMasterFragmentsByName.containsKey(rels.get((int)0).target) ? this.slideMasterFragmentsByName.get(rels.get((int)0).target) : new SlideTemplateFragments.Empty();
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && "cSld".equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!"cSld".equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideFragments.Default slideLayoutFragments = new SlideFragments.Default(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), slideMasterFragments);
                slideLayoutFragments.readWith(eventReader);
                SlideFragments.Default default_ = slideLayoutFragments;
                return default_;
            }
        }
        return new SlideFragments.Empty(slideMasterFragments);
    }

    private Map<String, SlideFragments> slideFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideFragments = new HashMap<String, SlideFragments>(this.presentationFragments.slideNames().size());
        for (String name : this.presentationFragments.slideNames()) {
            slideFragments.put(name, this.slideFragmentsOf(name));
        }
        return slideFragments;
    }

    private SlideFragments slideFragmentsOf(String partName) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(partName).getRelByType(this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_LAYOUT));
        SlideFragments slideLayoutFragments = null != rels && !rels.isEmpty() && this.slideLayoutFragmentsByName.containsKey(rels.get((int)0).target) ? this.slideLayoutFragmentsByName.get(rels.get((int)0).target) : new SlideFragments.Empty(new SlideTemplateFragments.Empty());
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && "cSld".equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!"cSld".equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideFragments.Default slideFragments = new SlideFragments.Default(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), slideLayoutFragments);
                slideFragments.readWith(eventReader);
                SlideFragments.Default default_ = slideFragments;
                return default_;
            }
        }
        return new SlideFragments.Empty(slideLayoutFragments);
    }

    private Map<String, SlideFragments> notesMasterFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> notesMasterFragments = new HashMap<String, SlideFragments>(this.presentationFragments.notesMasterNames().size());
        for (String name : this.presentationFragments.notesMasterNames()) {
            notesMasterFragments.put(name, this.notesMasterFragmentsOf(name));
        }
        return notesMasterFragments;
    }

    private SlideFragments notesMasterFragmentsOf(String partName) throws IOException, XMLStreamException {
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && NotesMasterFragments.NOTES_MASTER.equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!NotesMasterFragments.NOTES_MASTER.equals(e.asStartElement().getName().getLocalPart())) continue;
                NotesMasterFragments notesMasterFragments = new NotesMasterFragments(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory());
                notesMasterFragments.readWith(eventReader);
                NotesMasterFragments notesMasterFragments2 = notesMasterFragments;
                return notesMasterFragments2;
            }
        }
        return new SlideTemplateFragments.Empty();
    }

    private Map<String, SlideFragments> notesSlideFragments() throws IOException, XMLStreamException {
        List<String> notesSlideNames = this.notesSlideNames();
        HashMap<String, SlideFragments> slideFragments = new HashMap<String, SlideFragments>(notesSlideNames.size());
        for (String name : notesSlideNames) {
            slideFragments.put(name, this.notesSlideFragmentsOf(name));
        }
        return slideFragments;
    }

    private List<String> notesSlideNames() throws IOException, XMLStreamException {
        ArrayList<String> names = new ArrayList<String>();
        String typeUri = this.generalDocument.documentRelationshipsNamespace().uri().concat(NOTES_SLIDE);
        for (String slideName : this.presentationFragments.slideNames()) {
            List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(slideName).getRelByType(typeUri);
            if (null == rels || rels.isEmpty()) continue;
            names.add(rels.get((int)0).target);
        }
        return names;
    }

    private SlideFragments notesSlideFragmentsOf(String partName) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(partName).getRelByType(this.generalDocument.documentRelationshipsNamespace().uri().concat(NOTES_MASTER));
        SlideTemplateFragments.Empty notesMasterFragments = null != rels && !rels.isEmpty() && this.notesMasterFragmentsByName.containsKey(rels.get((int)0).target) ? this.notesMasterFragmentsByName.get(rels.get((int)0).target) : new SlideTemplateFragments.Empty();
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && "cSld".equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!"cSld".equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideFragments.Default slideFragments = new SlideFragments.Default(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), notesMasterFragments);
                slideFragments.readWith(eventReader);
                SlideFragments.Default default_ = slideFragments;
                return default_;
            }
        }
        return new SlideFragments.Empty(notesMasterFragments);
    }

    private Map<String, String> comments() throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.relsByEntry(this.presentationFragments.slideNames(), namespaceUri.concat(COMMENTS));
    }

    private Map<String, String> notes() throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.relsByEntry(this.presentationFragments.slideNames(), namespaceUri.concat(NOTES_SLIDE));
    }

    private Map<String, String> charts() throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.relsByEntry(this.presentationFragments.slideNames(), namespaceUri.concat(CHART));
    }

    private Map<String, String> diagramDatas() throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.relsByEntry(this.presentationFragments.slideNames(), namespaceUri.concat(DIAGRAM_DATA));
    }

    @Override
    public boolean hasPostponedTranslatables() {
        return false;
    }

    @Override
    public void updatePostponedTranslatables(String key, String value) {
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        ParseType parseType;
        ZipEntry entry = this.entries.nextElement();
        String contentType = this.generalDocument.contentTypeFor(entry);
        this.relsNameMatcher.reset(entry.getName());
        if (PowerpointDocument.isRelationshipsPart(contentType) && this.relsNameMatcher.matches() && this.generalDocument.conditionalParameters().getExtractExternalHyperlinks()) {
            return new RelationshipsPart(this.generalDocument, entry);
        }
        if (!this.isTranslatablePart(entry)) {
            if (PowerpointDocument.isModifiablePart(contentType)) {
                return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (this.isStyledTextPart(entry)) {
            if (this.isSlidablePart(entry.getName(), contentType)) {
                return new SlidablePart(this.generalDocument, entry, this.slideFragmentsFor(entry.getName(), contentType));
            }
            StyleDefinitions.Empty styleDefinitions = new StyleDefinitions.Empty();
            StyleOptimisation styleOptimisation = this.styleOptimisationFor(entry, styleDefinitions);
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        this.generalDocument.conditionalParameters().nFileType = parseType = this.getParseType(contentType);
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    private static boolean isRelationshipsPart(String contentType) {
        return "application/vnd.openxmlformats-package.relationships+xml".equals(contentType);
    }

    private StyleOptimisation styleOptimisationFor(ZipEntry entry, StyleDefinitions styleDefinitions) throws IOException, XMLStreamException {
        Namespace namespace = this.generalDocument.namespacesOf(entry).forPrefix("a");
        if (null == namespace) {
            return new StyleOptimisation.Bypass();
        }
        return new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), new QName(namespace.uri(), "pPr", namespace.prefix()), new QName(namespace.uri(), "defRPr", namespace.prefix()), Collections.emptyList(), styleDefinitions);
    }

    private ParseType getParseType(String contentType) {
        ParseType parseType;
        if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        } else if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            parseType = ParseType.MSPOWERPOINTCOMMENTS;
        } else {
            throw new IllegalStateException("Unexpected content type " + contentType);
        }
        return parseType;
    }

    private boolean isTranslatablePart(ZipEntry entry) throws IOException, XMLStreamException {
        String type = this.generalDocument.contentTypeFor(entry);
        if (!entry.getName().endsWith(".xml")) {
            return false;
        }
        if (this.isExcluded(entry.getName(), type)) {
            return false;
        }
        if (this.isHidden(entry.getName(), type)) {
            return false;
        }
        if (this.generalDocument.conditionalParameters().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (this.generalDocument.conditionalParameters().getTranslateComments() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            return true;
        }
        return this.isStyledTextPart(entry);
    }

    private static boolean isModifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.theme+xml".equals(contentType);
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml")) {
            return true;
        }
        return this.isSlidablePart(entry.getName(), type);
    }

    private boolean isSlidablePart(String entryName, String type) {
        return null != this.slideFragmentsFor(entryName, type);
    }

    private SlideFragments slideFragmentsFor(String entryName, String type) {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters()) {
            if ("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml".equals(type) && this.slideMasterFragmentsByName.containsKey(entryName)) {
                return this.slideMasterFragmentsByName.get(entryName);
            }
            if ("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml".equals(type) && this.slideLayoutFragmentsByName.containsKey(entryName)) {
                return this.slideLayoutFragmentsByName.get(entryName);
            }
        }
        if ("application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(type) && this.slideFragmentsByName.containsKey(entryName)) {
            return this.slideFragmentsByName.get(entryName);
        }
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointNotes()) {
            if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters() && "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml".equals(type) && this.notesMasterFragmentsByName.containsKey(entryName)) {
                return this.notesMasterFragmentsByName.get(entryName);
            }
            if ("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml".equals(type) && this.notesSlideFragmentsByName.containsKey(entryName)) {
                return this.notesSlideFragmentsByName.get(entryName);
            }
        }
        return null;
    }

    private boolean isExcluded(String entryName, String contentType) {
        return this.isExcludedSlide(entryName, contentType) || this.isExcludedNote(entryName, contentType) || this.isExcludedComment(entryName, contentType) || this.isExcludedChart(entryName, contentType) || this.isExcludedDiagramData(entryName, contentType);
    }

    private boolean isExcludedSlide(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(contentType)) {
            return false;
        }
        if (!this.generalDocument.conditionalParameters().getPowerpointIncludedSlideNumbersOnly()) {
            return false;
        }
        int slideIndex = this.presentationFragments.slideNames().indexOf(entryName);
        if (slideIndex == -1) {
            return false;
        }
        int slideNumber = slideIndex + 1;
        return !this.generalDocument.conditionalParameters().tsPowerpointIncludedSlideNumbers.contains(slideNumber);
    }

    private boolean isExcludedNote(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml".equals(contentType) || !this.slidesByNote.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByNote.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedComment(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.comments+xml".equals(contentType) || !this.slidesByComment.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByComment.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedChart(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(contentType) || !this.slidesByChart.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByChart.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedDiagramData(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml".equals(contentType) || !this.slidesByDiagramData.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByDiagramData.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isHidden(String entryName, String type) throws IOException, XMLStreamException {
        if (!this.generalDocument.conditionalParameters().getTranslatePowerpointHidden() && "application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(type)) {
            return this.isHiddenSlide(entryName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHiddenSlide(String entryName) throws IOException, XMLStreamException {
        XMLEventReader eventReader = null;
        try {
            eventReader = this.generalDocument.inputFactory().createXMLEventReader(this.generalDocument.getPartReader(entryName));
            boolean bl = PresentationSlide.fromXMLEventReader(eventReader).isHidden();
            return bl;
        }
        finally {
            if (null != eventReader) {
                eventReader.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

