/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Property;

public interface IWithBilingualProperties {
    public static void copy(IWithBilingualProperties from, IWithBilingualProperties to) {
        if (from == null || to == null) {
            return;
        }
        for (String propName : from.getSourcePropertyNames()) {
            if (to.hasSourceProperty(propName)) continue;
            to.setSourceProperty(from.getSourceProperty(propName).clone());
        }
        for (LocaleId trgLocale : from.getTargetLocales()) {
            for (String propName : from.getTargetPropertyNames(trgLocale)) {
                if (to.hasTargetProperty(trgLocale, propName)) continue;
                to.setTargetProperty(trgLocale, from.getTargetProperty(trgLocale, propName).clone());
            }
        }
    }

    public Property getSourceProperty(String var1);

    public Set<String> getSourcePropertyNames();

    public Set<LocaleId> getTargetLocales();

    public Property getTargetProperty(LocaleId var1, String var2);

    public Set<String> getTargetPropertyNames(LocaleId var1);

    public boolean hasSourceProperty(String var1);

    public boolean hasTargetProperty(LocaleId var1, String var2);

    public void removeSourceProperty(String var1);

    public void removeTargetProperty(LocaleId var1, String var2);

    public Property setSourceProperty(Property var1);

    public Property setTargetProperty(LocaleId var1, Property var2);
}

