/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.Parameters;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class TMXFilterWriter
implements IFilterWriter {
    private TMXWriter writer;
    private OutputStream outputStream;
    private String outputPath;
    private LocaleId locale;
    private boolean canceled;
    private String segType;
    private Parameters params = new Parameters();
    private List<Event> delayedEvents;
    private LocaleId sourceLocale;

    public TMXFilterWriter() {
        this.delayedEvents = new LinkedList<Event>();
    }

    public TMXFilterWriter(TMXWriter writer) {
        this.writer = writer;
    }

    public void setSegType(String segType) {
        this.segType = segType;
    }

    @Override
    public void cancel() {
        this.close();
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.writeEndDocument();
        this.writer.close();
        this.writer = null;
    }

    @Override
    public String getName() {
        return "TMXFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public Event handleEvent(Event event) {
        if (this.canceled) {
            return new Event(EventType.CANCELED);
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.sourceLocale = event.getStartDocument().getLocale();
                if (!Util.isNullOrEmpty(this.sourceLocale)) {
                    this.processStartDocument(event);
                    break;
                }
                this.delayedEvents.add(event);
                break;
            }
            case END_DOCUMENT: {
                this.sourceLocale = null;
                this.processEndDocument();
                break;
            }
            case TEXT_UNIT: {
                if (!Util.isNullOrEmpty(this.sourceLocale)) {
                    this.processTextUnit(event);
                    break;
                }
                this.delayedEvents.add(event);
                break;
            }
            case MULTI_EVENT: {
                for (Event e : event.getMultiEvent()) {
                    this.handleEvent(e);
                }
                break;
            }
            case END_SUBDOCUMENT: {
                this.writer.setTrgLoc(this.locale);
                break;
            }
            case PIPELINE_PARAMETERS: {
                if (!this.delayedEvents.isEmpty()) {
                    this.sourceLocale = event.getPipelineParameters().getSourceLocale();
                    this.delayedEvents.get(0).getStartDocument().setLocale(this.sourceLocale);
                    for (Event e : this.delayedEvents) {
                        this.handleEvent(e);
                    }
                    this.delayedEvents.clear();
                }
                this.processPipelineParameters(event);
                break;
            }
        }
        return event;
    }

    private void processPipelineParameters(Event event) {
        PipelineParameters pp = event.getPipelineParameters();
        if (pp.getSourceLocale() != null) {
            this.writer.setSrcLoc(pp.getSourceLocale());
        }
        if (pp.getTargetLocale() != null) {
            this.writer.setTrgLoc(pp.getTargetLocale());
        }
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.locale = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void processStartDocument(Event event) {
        StartDocument sd = (StartDocument)event.getResource();
        if (this.outputStream == null) {
            if (this.writer == null) {
                this.writer = new TMXWriter(this.outputPath);
            } else {
                this.writer.setPath(this.outputPath);
            }
        } else if (this.outputStream != null) {
            if (this.writer == null) {
                this.writer = new TMXWriter(new XMLWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8)));
            } else {
                this.writer.setXmlWriter(new XMLWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8)));
            }
        }
        this.writer.setWriteAllPropertiesAsAttributes(this.params.isWriteAllPropertiesAsAttributes());
        this.writer.setExpandDuplicateProps(this.params.isEnableDuplicateProps());
        this.writer.setPropValueSep(this.params.getPropValueSep());
        this.writer.setGenerateUUID(this.params.isGenerateUUID());
        this.writer.setNormalizeCodeIds(this.params.isNormalizeInlineIDs());
        this.writer.writeStartDocument(sd, sd.getLocale(), this.locale, null, null, this.segType, "unknown", "text");
    }

    private void processEndDocument() {
        this.close();
    }

    private void processTextUnit(Event event) {
        this.writer.writeTUFull(event.getTextUnit());
    }
}

