/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.steps;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.extra.steps.DocumentPartLogger;
import net.sf.okapi.lib.extra.steps.TextUnitLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuDpLogger
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private StringBuilder sb;
    private LocaleId srcLoc;
    private int index;
    private boolean immediate;

    public TuDpLogger() {
        this(false);
    }

    public TuDpLogger(boolean immediate) {
        this.immediate = immediate;
    }

    @Override
    public String getName() {
        return "Text Unit and Document Part Logger";
    }

    @Override
    public String getDescription() {
        return "Logs Text Unit and Document Part resources going through the pipeline.";
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.sb = new StringBuilder("\n\n");
        return super.handleStartBatch(event);
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = (StartDocument)event.getResource();
        this.srcLoc = sd.getLocale();
        this.index = 0;
        return super.handleStartDocument(event);
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.sb.append(this.index++);
        this.sb.append("=========== \n");
        ITextUnit tu = event.getTextUnit();
        this.sb.append(TextUnitLogger.getTuInfo(tu, this.srcLoc));
        this.flushImmediate();
        return super.handleTextUnit(event);
    }

    private void flushImmediate() {
        if (!this.immediate) {
            return;
        }
        this.sb = new StringBuilder();
    }

    @Override
    protected Event handleDocumentPart(Event event) {
        this.sb.append(this.index++);
        this.sb.append("=========== \n");
        DocumentPart dp = event.getDocumentPart();
        this.sb.append(DocumentPartLogger.getDpInfo(dp, this.srcLoc));
        this.flushImmediate();
        return super.handleDocumentPart(event);
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (!this.immediate) {
            this.logger.trace(this.sb.toString());
        }
        return super.handleEndBatch(event);
    }
}

