/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.properties;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filters.LocalizationDirectives;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    private static final String USELD = "useLd";
    private static final String LOCALIZEOUTSIDE = "localizeOutside";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String CONVERTLFANDTAB = "convertLFandTab";
    private static final String USEKEYCONDITION = "useKeyCondition";
    private static final String EXTRACTONLYMATCHINGKEY = "extractOnlyMatchingKey";
    private static final String KEYCONDITION = "keyCondition";
    private static final String EXTRACOMMENTS = "extraComments";
    private static final String COMMENTSARENOTES = "commentsAreNotes";
    private static final String ESCAPEEXTENDEDCHARS = "escapeExtendedChars";
    private static final String SUBFILTER = "subfilter";
    private static final String IDLIKERESNAME = "idLikeResname";
    private static final String USEJAVAESCAPES = "useJavaEscapes";
    public InlineCodeFinder codeFinder;
    public LocalizationDirectives locDir;

    @Override
    public void reset() {
        super.reset();
        this.locDir = new LocalizationDirectives();
        this.setEscapeExtendedChars(true);
        this.setConvertLFandTab(true);
        this.setUseKeyCondition(false);
        this.setExtractOnlyMatchingKey(true);
        this.setKeyCondition(".*text.*");
        this.setExtraComments(false);
        this.setCommentsAreNotes(true);
        this.setSubfilter(null);
        this.setIdLikeResname(false);
        this.setUseJavaEscapes(false);
        this.setUseCodeFinder(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("%s, %d, {1}, \\n, \\r, \\t, etc.");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]");
        this.codeFinder.addRule("(\\\\r\\\\n)|\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("\\{\\d[^\\\\]*?\\}");
        this.codeFinder.addRule("\\<(/?)\\w+[^>]*?>");
        this.setSimplifierRules(null);
    }

    @Override
    public String toString() {
        this.buffer.setBoolean(USELD, this.locDir.useLD());
        this.buffer.setBoolean(LOCALIZEOUTSIDE, this.locDir.localizeOutside());
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        boolean tmpBool1 = this.buffer.getBoolean(USELD, this.locDir.useLD());
        boolean tmpBool2 = this.buffer.getBoolean(LOCALIZEOUTSIDE, this.locDir.localizeOutside());
        this.locDir.setOptions(tmpBool1, tmpBool2);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    public boolean isUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public void setCodeFinder(InlineCodeFinder codeFinder) {
        this.codeFinder = codeFinder;
    }

    public boolean isEscapeExtendedChars() {
        return this.getBoolean(ESCAPEEXTENDEDCHARS);
    }

    public void setEscapeExtendedChars(boolean escapeExtendedChars) {
        this.setBoolean(ESCAPEEXTENDEDCHARS, escapeExtendedChars);
    }

    public boolean isUseKeyCondition() {
        return this.getBoolean(USEKEYCONDITION);
    }

    public void setUseKeyCondition(boolean useKeyCondition) {
        this.setBoolean(USEKEYCONDITION, useKeyCondition);
    }

    public boolean isExtractOnlyMatchingKey() {
        return this.getBoolean(EXTRACTONLYMATCHINGKEY);
    }

    public void setExtractOnlyMatchingKey(boolean extractOnlyMatchingKey) {
        this.setBoolean(EXTRACTONLYMATCHINGKEY, extractOnlyMatchingKey);
    }

    public String getKeyCondition() {
        return this.getString(KEYCONDITION);
    }

    public void setKeyCondition(String keyCondition) {
        this.setString(KEYCONDITION, keyCondition);
    }

    public boolean isExtraComments() {
        return this.getBoolean(EXTRACOMMENTS);
    }

    public void setExtraComments(boolean extraComments) {
        this.setBoolean(EXTRACOMMENTS, extraComments);
    }

    public boolean isCommentsAreNotes() {
        return this.getBoolean(COMMENTSARENOTES);
    }

    public void setCommentsAreNotes(boolean commentsAreNotes) {
        this.setBoolean(COMMENTSARENOTES, commentsAreNotes);
    }

    public LocalizationDirectives getLocDir() {
        return this.locDir;
    }

    public void setLocDir(LocalizationDirectives locDir) {
        this.locDir = locDir;
    }

    public boolean isConvertLFandTab() {
        return this.getBoolean(CONVERTLFANDTAB);
    }

    public void setConvertLFandTab(boolean convertLFandTab) {
        this.setBoolean(CONVERTLFANDTAB, convertLFandTab);
    }

    public boolean isIdLikeResname() {
        return this.getBoolean(IDLIKERESNAME);
    }

    public void setIdLikeResname(boolean idLikeResname) {
        this.setBoolean(IDLIKERESNAME, idLikeResname);
    }

    public boolean isUseJavaEscapes() {
        return this.getBoolean(USEJAVAESCAPES);
    }

    public void setUseJavaEscapes(boolean escapeJavaChars) {
        this.setBoolean(USEJAVAESCAPES, escapeJavaChars);
    }

    public String getSubfilter() {
        return this.getString(SUBFILTER);
    }

    public void setSubfilter(String subfilter) {
        this.setString(SUBFILTER, subfilter);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

