/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.MasterAndPagePart;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class VisioDocument
implements Document {
    private static final String MASTERS = Namespaces.VisioDocumentRelationships.getDerivedURI("/masters");
    private static final String PAGES = Namespaces.VisioDocumentRelationships.getDerivedURI("/pages");
    private static final String MASTER = Namespaces.VisioDocumentRelationships.getDerivedURI("/master");
    private static final String PAGE = Namespaces.VisioDocumentRelationships.getDerivedURI("/page");
    private final Document.General generalDocument;
    private Enumeration<? extends ZipEntry> entries;
    private List<String> mastersAndPages;

    VisioDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.mastersAndPages = this.mastersAndPages();
        this.entries = this.entries();
        return this.generalDocument.startDocumentEvent();
    }

    private List<String> mastersAndPages() throws IOException, XMLStreamException {
        Relationships relationships = this.generalDocument.relationshipsForPartName(this.generalDocument.mainPartName());
        List<Relationships.Rel> masters = relationships.getRelByType(MASTERS);
        if (masters == null || masters.size() != 1) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        List<Relationships.Rel> pages = relationships.getRelByType(PAGES);
        if (pages == null || pages.size() != 1) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        Relationships masterRelationships = this.generalDocument.relationshipsForPartName(masters.get((int)0).target);
        Relationships pageRelationships = this.generalDocument.relationshipsForPartName(pages.get((int)0).target);
        List<String> targets = Relationships.mapRelsToTargets(masterRelationships.getRelByType(MASTER));
        targets.addAll(Relationships.mapRelsToTargets(pageRelationships.getRelByType(PAGE)));
        return targets;
    }

    private Enumeration<? extends ZipEntry> entries() {
        ArrayList<? extends ZipEntry> entries = Collections.list(this.generalDocument.entries());
        entries.sort(new ZipEntryComparator(this.mastersAndPages));
        return Collections.enumeration(entries);
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        return false;
    }

    @Override
    public boolean hasPostponedTranslatables() {
        return false;
    }

    @Override
    public void updatePostponedTranslatables(String key, String value) {
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements();
    }

    @Override
    public Part nextPart() {
        ZipEntry entry = this.entries.nextElement();
        if (!this.isTranslatablePart(entry)) {
            return new NonModifiablePart(this.generalDocument, entry);
        }
        return new MasterAndPagePart(this.generalDocument, entry);
    }

    private boolean isTranslatablePart(ZipEntry entry) {
        String contentType = this.generalDocument.contentTypeFor(entry);
        return entry.getName().endsWith(".xml") && (VisioDocument.isMasterPart(contentType) || VisioDocument.isPagePart(contentType));
    }

    private static boolean isMasterPart(String type) {
        return "application/vnd.ms-visio.master+xml".equals(type);
    }

    private static boolean isPagePart(String type) {
        return "application/vnd.ms-visio.page+xml".equals(type);
    }

    @Override
    public void close() throws IOException {
    }
}

