/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.namespace.QName;

enum Namespaces {
    Empty(""),
    XML("http://www.w3.org/XML/1998/namespace"),
    Relationships("http://schemas.openxmlformats.org/package/2006/relationships"),
    WordProcessingML("http://schemas.openxmlformats.org/wordprocessingml/2006/main"),
    StrictWordProcessingML("http://purl.oclc.org/ooxml/ooxml/wordprocessingml/main"),
    SpreadsheetML("http://schemas.openxmlformats.org/spreadsheetml/2006/main"),
    PresentationML("http://schemas.openxmlformats.org/presentationml/2006/main"),
    DrawingML("http://schemas.openxmlformats.org/drawingml/2006/main"),
    Math("http://schemas.openxmlformats.org/officeDocument/2006/math"),
    Chart("http://schemas.openxmlformats.org/drawingml/2006/chart"),
    VML("urn:schemas-microsoft-com:vml"),
    WordProcessingDrawingML("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"),
    StrictWordProcessingDrawingML("http://purl.oclc.org/ooxml/drawingml/wordprocessingDrawing"),
    MarkupCompatibility("http://schemas.openxmlformats.org/markup-compatibility/2006"),
    DocumentRelationships("http://schemas.openxmlformats.org/officeDocument/2006/relationships"),
    StrictDocumentRelationships("http://purl.oclc.org/ooxml/officeDocument/relationships"),
    VisioDocumentRelationships("http://schemas.microsoft.com/visio/2010/relationships");

    private final String nsURI;

    private Namespaces(String nsURI) {
        this.nsURI = nsURI;
    }

    static Namespaces fromNamespaceURI(String namespaceURI) {
        if (null == namespaceURI) {
            return Empty;
        }
        for (Namespaces namespace : Namespaces.values()) {
            if (!namespaceURI.equals(namespace.getURI())) continue;
            return namespace;
        }
        return Empty;
    }

    String getURI() {
        return this.nsURI;
    }

    QName getQName(String localPart) {
        return new QName(this.nsURI, localPart, "");
    }

    QName getQName(String localPart, String prefix) {
        return new QName(this.nsURI, localPart, prefix);
    }

    String getDerivedURI(String path) {
        StringBuilder sb = new StringBuilder(this.nsURI);
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(path);
        return sb.toString();
    }

    boolean containsName(QName name) {
        return this.nsURI.equals(name.getNamespaceURI());
    }
}

