/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEvents;

class Block
implements XMLEvents,
Textual {
    private final List<Chunk> chunks;
    private final StyleOptimisation styleOptimisation;
    private QName runName;
    private QName textName;
    private final boolean hidden;
    private final boolean skipped;
    private final boolean mergeable;
    private final Collection<XMLEvent> deferredEvents;

    Block(List<Chunk> chunks, StyleOptimisation styleOptimisation, QName runName, QName textName, boolean hidden, boolean skipped, boolean mergeable, Collection<XMLEvent> deferredEvents) {
        this.chunks = chunks;
        this.styleOptimisation = styleOptimisation;
        this.runName = runName;
        this.textName = textName;
        this.hidden = hidden;
        this.skipped = skipped;
        this.mergeable = mergeable;
        this.deferredEvents = deferredEvents;
    }

    QName getRunName() {
        return this.runName;
    }

    QName getTextName() {
        return this.textName;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        for (XMLEvents xMLEvents : this.chunks) {
            events.addAll(xMLEvents.getEvents());
        }
        return events;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    boolean isHidden() {
        return this.hidden;
    }

    boolean isSkipped() {
        return this.skipped;
    }

    boolean isMergeable() {
        return this.mergeable;
    }

    void mergeWith(Block mergeableBlock) {
        if (mergeableBlock.chunks.size() <= 2) {
            return;
        }
        List<Chunk> mergeableChunks = mergeableBlock.chunks.subList(1, mergeableBlock.chunks.size() - 1);
        ListIterator<Chunk> iterator = this.chunks.listIterator(1);
        ParagraphBlockProperties properties = ((Markup)this.chunks.get(0)).paragraphBlockProperties();
        boolean refinedInline = false;
        for (Chunk chunk : mergeableChunks) {
            if (chunk instanceof Run && ((Run)chunk).containsParagraphBlockProperties()) {
                ((Run)chunk).refineParagraphBlockProperties(properties);
                refinedInline = true;
            }
            iterator.add(chunk);
        }
        if (refinedInline) {
            ((Markup)this.chunks.get(0)).updateOrAddBlockProperties(((Markup)mergeableBlock.chunks.get(0)).paragraphBlockProperties());
        }
        if (Objects.isNull(this.runName)) {
            this.runName = mergeableBlock.runName;
        }
        if (Objects.isNull(this.textName)) {
            this.textName = mergeableBlock.textName;
        }
    }

    void optimiseStyles() throws XMLStreamException {
        this.styleOptimisation.applyTo(this.chunks);
    }

    boolean hasVisibleRunContent() {
        for (Chunk chunk : this.chunks) {
            if (!(chunk instanceof Run ? ((Run)chunk).containsVisibleText() : chunk instanceof RunContainer && ((RunContainer)chunk).containsVisibleText())) continue;
            return true;
        }
        return false;
    }

    Collection<XMLEvent> deferredEvents() {
        return this.deferredEvents;
    }

    public String toString() {
        return "Block [" + this.chunks + "]";
    }

    static class Builder
    implements ChunkContainer {
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private StyleOptimisation styleOptimisation;
        private QName runName;
        private QName textName;
        private boolean hidden = false;
        private boolean skipped = false;
        private boolean mergeable = false;
        private Collection<XMLEvent> deferredEvents = new LinkedList<XMLEvent>();
        private MarkupBuilder markupBuilder = new MarkupBuilder(new Markup(new Markup.General(new ArrayList<MarkupComponent>())));

        Builder() {
        }

        @Override
        public void add(Chunk chunk) {
            this.flushMarkup();
            this.chunks.add(chunk);
        }

        void runName(QName runName) {
            if (this.runName == null) {
                this.runName = runName;
            }
        }

        void textName(QName textName) {
            if (this.textName == null) {
                this.textName = textName;
            }
        }

        void styleOptimisation(StyleOptimisation styleOptimisation) {
            this.styleOptimisation = styleOptimisation;
        }

        boolean hidden() {
            return this.hidden;
        }

        void hidden(boolean hidden) {
            this.hidden = hidden;
        }

        void skipped(boolean skipped) {
            this.skipped = skipped;
        }

        void mergeable(boolean mergeable) {
            if (!this.mergeable) {
                this.mergeable = mergeable;
            }
        }

        void addDeferredEvents(Collection<XMLEvent> deferredEvents) {
            this.deferredEvents.addAll(deferredEvents);
        }

        void addToMarkup(XMLEvent event) {
            this.markupBuilder.add(event);
        }

        void addToMarkup(MarkupComponent markupComponent) {
            this.markupBuilder.add(markupComponent);
        }

        boolean chunksEmpty() {
            return this.chunks.isEmpty();
        }

        void flushMarkup() {
            Markup markup = (Markup)this.markupBuilder.build();
            if (!markup.components().isEmpty()) {
                this.chunks.add(markup);
                this.markupBuilder = new MarkupBuilder(new Markup(new Markup.General(new ArrayList<MarkupComponent>())));
            }
        }

        Block build() {
            this.flushMarkup();
            return new Block(this.chunks, this.styleOptimisation, this.runName, this.textName, this.hidden, this.skipped, this.mergeable, this.deferredEvents);
        }
    }

    static class Markup
    implements net.sf.okapi.filters.openxml.Markup,
    Chunk {
        private static final String START_MARKUP_COMPONENT_IS_NOT_FOUND = "Unexpected structure: the start markup component is not found";
        private final Markup.General generalMarkup;

        Markup(Markup.General generalMarkup) {
            this.generalMarkup = generalMarkup;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.generalMarkup.getEvents();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.generalMarkup.apply(fontMappings);
        }

        @Override
        public void addComponent(MarkupComponent component) {
            this.generalMarkup.addComponent(component);
        }

        @Override
        public void addComponents(List<MarkupComponent> components) {
            this.generalMarkup.addComponents(components);
        }

        @Override
        public void addMarkup(net.sf.okapi.filters.openxml.Markup markup) {
            this.generalMarkup.addMarkup(markup);
        }

        @Override
        public List<MarkupComponent> components() {
            return this.generalMarkup.components();
        }

        @Override
        public Nameable nameableComponent() {
            return this.generalMarkup.nameableComponent();
        }

        ParagraphBlockProperties paragraphBlockProperties() {
            for (MarkupComponent markupComponent : this.components()) {
                if (!(markupComponent instanceof ParagraphBlockProperties)) continue;
                return (ParagraphBlockProperties)markupComponent;
            }
            return null;
        }

        void updateOrAddBlockProperties(BlockProperties blockProperties) {
            ListIterator<MarkupComponent> componentsIterator = this.components().listIterator();
            while (componentsIterator.hasNext()) {
                MarkupComponent markupComponent = componentsIterator.next();
                if (!(markupComponent instanceof BlockProperties)) continue;
                componentsIterator.set(blockProperties);
                return;
            }
            Markup.rewindAfterStartMarkupComponent(componentsIterator);
            componentsIterator.add(blockProperties);
        }

        private static void rewindAfterStartMarkupComponent(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasPrevious()) {
                if (!(iterator.previous() instanceof MarkupComponent.Start)) continue;
                iterator.next();
                return;
            }
            throw new IllegalStateException(START_MARKUP_COMPONENT_IS_NOT_FOUND);
        }
    }
}

