/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.icml;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.icml.ICMLFilter;
import net.sf.okapi.filters.icml.ICMLSkeleton;
import net.sf.okapi.filters.icml.NodeReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ICMLContext {
    private static String ATTRIBUTENAME_MARKUPTAG = "MarkupTag";
    private static String ATTRIBUTEVALUE_XMLTAG = "XMLTag";
    private static String ATTRIBUTENAME_APPLIEDCHARACTERSTYLE = "AppliedCharacterStyle";
    private static String ATTRIBUTENAME_APPLIEDPARAGRAPHSTYLE = "AppliedParagraphStyle";
    private static String PREFIX_CTYPE_TAG = "x-tag_";
    private static String PREFIX_CTYPE_CHARACTERSTYLE = "x-cs_";
    private static String PREFIX_CTYPE_PARAGRAPHSTYLE = "x-ps_";
    private boolean inScope;
    private Node topNode;
    private Node scopeNode;
    private TextFragment tf;
    private boolean isReferent;
    private ICMLSkeleton skel;
    private String tuId;
    private static final boolean phOnly = false;

    public ICMLContext(boolean isReferent, Node topNode) {
        this.isReferent = isReferent;
        this.topNode = topNode;
    }

    public void enterScope(Node scopeNode, String tuId) {
        this.scopeNode = scopeNode;
        this.tuId = tuId;
        this.tf = new TextFragment();
        this.inScope = true;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public Node getScopeNode() {
        return this.scopeNode;
    }

    public ICMLSkeleton getSkeleton() {
        return this.skel;
    }

    public void leaveScope() {
        this.inScope = false;
        this.skel = null;
    }

    public boolean inScope() {
        return this.inScope;
    }

    public boolean addToQueue(List<Event> queue, boolean evenIfEmpty) {
        if (this.tf.isEmpty() && !evenIfEmpty) {
            return false;
        }
        TextUnit tu = new TextUnit(this.tuId, null, this.isReferent);
        tu.setSourceContent(this.tf);
        tu.setPreserveWhitespaces(true);
        if (this.skel == null) {
            this.skel = new ICMLSkeleton(this.topNode, this.scopeNode);
        }
        tu.setSkeleton(this.skel);
        queue.add(new Event(EventType.TEXT_UNIT, tu));
        return true;
    }

    public void addContent(Element elem) {
        String endTag = "</" + elem.getNodeName() + ">";
        this.tf.append(TextFragment.TagType.OPENING, "code", this.buildStartTag(elem, false));
        ICMLFilter.processContent(elem, this.tf);
        this.tf.append(TextFragment.TagType.CLOSING, "code", endTag);
    }

    public void addCode(Code code) {
        this.tf.append(code);
    }

    public void addCode(Node node) {
        if (node.getNodeType() == 3) {
            String text = node.getNodeValue();
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                this.tf.append(TextFragment.TagType.PLACEHOLDER, "text", text);
                return;
            }
        } else if (node.getNodeType() == 4) {
            this.tf.append(TextFragment.TagType.PLACEHOLDER, "cdata", "<![CDATA[" + node.getNodeValue() + "]]>");
        }
    }

    public void addReference(String key, NodeReference ref) {
        if (this.skel == null) {
            this.skel = new ICMLSkeleton(this.topNode, this.scopeNode);
        }
        this.skel.addReferenceNode(key, ref);
    }

    public void addStartTag(Element elem) {
        this.tf.append(elem.hasChildNodes() ? TextFragment.TagType.OPENING : TextFragment.TagType.PLACEHOLDER, this.getCtype(elem), this.buildStartTag(elem));
    }

    public void addEndTag(Element elem) {
        if (elem.hasChildNodes()) {
            this.tf.append(TextFragment.TagType.CLOSING, this.getCtype(elem), this.buildEndTag(elem));
        }
    }

    public String buildStartTag(Element elem) {
        return this.buildStartTag(elem, true);
    }

    public String buildStartTag(Element elem, boolean selfClosing) {
        StringBuilder sb = new StringBuilder("<" + elem.getNodeName());
        NamedNodeMap attrNames = elem.getAttributes();
        for (int i = 0; i < attrNames.getLength(); ++i) {
            Attr attr = (Attr)attrNames.item(i);
            sb.append(" " + attr.getName() + "=\"");
            sb.append(Util.escapeToXML(attr.getValue(), 3, false, null));
            sb.append("\"");
        }
        if (elem.hasChildNodes() || !selfClosing) {
            sb.append(">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    public String buildEndTag(Element elem) {
        if (elem.hasChildNodes()) {
            return "</" + elem.getNodeName() + ">";
        }
        return "";
    }

    private String getCtype(Element elem) {
        String elementName = elem.getNodeName();
        String cStyle = this.getCharacterStyle(elem);
        String tStyle = this.getXmlMarkUp(elem);
        String pStyle = this.getParagraphStyle(elem);
        if (pStyle != null && pStyle.length() > 1) {
            elementName = PREFIX_CTYPE_PARAGRAPHSTYLE + pStyle;
        } else if (cStyle != null && cStyle.length() > 1) {
            elementName = PREFIX_CTYPE_CHARACTERSTYLE + cStyle;
        } else if (tStyle != null && tStyle.length() > 1) {
            elementName = PREFIX_CTYPE_TAG + tStyle;
        }
        return elementName;
    }

    private String getParagraphStyle(Element elem) {
        String pStyle = elem.getAttribute(ATTRIBUTENAME_APPLIEDPARAGRAPHSTYLE);
        if (pStyle != null && pStyle.length() > 1) {
            pStyle = pStyle.substring(pStyle.lastIndexOf("/") + 1).replace(" ", "").replace("[", "").replace("]", "").toUpperCase();
        }
        return pStyle;
    }

    private String getCharacterStyle(Element elem) {
        String cStyle = elem.getAttribute(ATTRIBUTENAME_APPLIEDCHARACTERSTYLE);
        if (cStyle != null && cStyle.length() > 1) {
            cStyle = cStyle.substring(cStyle.lastIndexOf("/") + 1).replace(" ", "").replace("[", "").replace("]", "").toUpperCase();
        }
        return cStyle;
    }

    private String getXmlMarkUp(Element elem) {
        String tStyle = elem.getAttribute(ATTRIBUTENAME_MARKUPTAG);
        if (tStyle != null && tStyle.length() > 1 && tStyle.startsWith(ATTRIBUTEVALUE_XMLTAG + "/")) {
            tStyle = tStyle.substring(tStyle.indexOf("/") + 1).toUpperCase();
        }
        return tStyle;
    }
}

